/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets;

import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import org.terasology.gestalt.assets.format.AssetDataFile;

public class AssetDataFileHandle
extends FileHandle {
    protected AssetDataFile dataFile;

    public AssetDataFileHandle(AssetDataFile dataFile) {
        this.dataFile = dataFile;
    }

    public BufferedInputStream read(int bufferSize) {
        return new BufferedInputStream(this.read());
    }

    public InputStream read() {
        try {
            return this.dataFile.openStream();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public String name() {
        return this.dataFile.getFilename();
    }

    public String extension() {
        return this.dataFile.getFileExtension();
    }

    public String nameWithoutExtension() {
        String fileName = this.name();
        return this.dataFile.getFilename().substring(0, fileName.lastIndexOf(".") + 1);
    }

    public String path() {
        List path = this.dataFile.getPath();
        StringBuilder builder = new StringBuilder();
        for (int segmentNo = 0; segmentNo < path.size(); ++segmentNo) {
            builder.append((String)path.get(segmentNo));
            if (segmentNo == path.size() - 1) continue;
            builder.append('/');
        }
        return builder.toString();
    }

    public FileHandle parent() {
        return this;
    }

    public FileHandle child(String name) {
        return new FileHandle(this.path() + "/" + name);
    }

    public String pathWithoutExtension() {
        String path = this.path();
        return path.substring(0, path.indexOf(this.extension()));
    }

    public String toString() {
        return this.path();
    }

    public long length() {
        int length = -1;
        try {
            InputStream stream = this.dataFile.openStream();
            length = stream.available();
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }
}

