/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets;

import java.util.Optional;
import java.util.Set;
import org.destinationsol.assets.music.AndroidOggMusicFileFormat;
import org.destinationsol.assets.music.OggMusic;
import org.destinationsol.assets.sound.AndroidOggSoundFileFormat;
import org.destinationsol.assets.sound.OggSound;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResolutionStrategy;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.AssetFileFormat;
import org.terasology.gestalt.assets.format.producer.ModuleDependencyProvider;
import org.terasology.gestalt.assets.module.ModuleAwareAssetTypeManager;
import org.terasology.gestalt.assets.module.ModuleAwareAssetTypeManagerImpl;
import org.terasology.gestalt.assets.module.ModuleDependencyResolutionStrategy;
import org.terasology.gestalt.assets.module.ModuleEnvironmentDependencyProvider;
import org.terasology.gestalt.entitysystem.component.management.ComponentManager;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeIndex;
import org.terasology.gestalt.entitysystem.prefab.Prefab;
import org.terasology.gestalt.entitysystem.prefab.PrefabJsonFormat;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.naming.Name;

public class AssetHelper {
    private ModuleAwareAssetTypeManager assetTypeManager;

    public void init(ModuleEnvironment environment, ComponentManager componentManager, boolean isMobile) {
        this.assetTypeManager = new ModuleAwareAssetTypeManagerImpl();
        if (isMobile) {
            AssetType soundType = this.assetTypeManager.createAssetType(OggSound.class, OggSound::new, new String[]{"sounds"});
            AssetType musicType = this.assetTypeManager.createAssetType(OggMusic.class, OggMusic::new, new String[]{"music"});
            this.assetTypeManager.getAssetFileDataProducer(soundType).addAssetFormat((AssetFileFormat)new AndroidOggSoundFileFormat());
            this.assetTypeManager.getAssetFileDataProducer(musicType).addAssetFormat((AssetFileFormat)new AndroidOggMusicFileFormat());
        }
        this.assetTypeManager.getAssetFileDataProducer(this.assetTypeManager.createAssetType(Prefab.class, Prefab::new, new String[]{"prefabs"})).addAssetFormat((AssetFileFormat)new PrefabJsonFormat.Builder(new ComponentTypeIndex(environment, (ResolutionStrategy)new ModuleDependencyResolutionStrategy((ModuleDependencyProvider)new ModuleEnvironmentDependencyProvider(environment))), componentManager, this.assetTypeManager.getAssetManager()).create());
        this.assetTypeManager.switchEnvironment(environment);
    }

    public <T extends Asset<U>, U extends AssetData> Optional<T> get(ResourceUrn urn, Class<T> type) {
        return this.assetTypeManager.getAssetManager().getAsset(urn, type);
    }

    public Set<ResourceUrn> list(Class<? extends Asset<?>> type) {
        return this.assetTypeManager.getAssetManager().getAvailableAssets(type);
    }

    public Set<ResourceUrn> listAssets(Class<? extends Asset<?>> type, String asset) {
        return this.assetTypeManager.getAssetManager().resolve(asset, type);
    }

    public Set<ResourceUrn> listAssets(Class<? extends Asset<?>> type, String asset, Name ... excluding) {
        Set<ResourceUrn> list = this.listAssets(type, asset);
        list.removeIf(urn -> {
            for (Name module : excluding) {
                if (!urn.getModuleName().equals((Object)module)) continue;
                return true;
            }
            return false;
        });
        return list;
    }
}

