/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.destinationsol.assets.AssetHelper;
import org.destinationsol.assets.emitters.Emitter;
import org.destinationsol.assets.fonts.Font;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.music.OggMusic;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.textures.DSTexture;
import org.destinationsol.game.drawables.SpriteManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.prefab.Prefab;

public abstract class Assets {
    private static AssetHelper assetHelper;
    private static Set<ResourceUrn> textureList;
    private static Logger logger;

    public static void initialize(AssetHelper helper) {
        assetHelper = helper;
    }

    public static AssetHelper getAssetHelper() {
        return assetHelper;
    }

    public static Prefab getPrefab(String path) {
        Optional<Prefab> prefabOptional = assetHelper.get(new ResourceUrn(path), Prefab.class);
        if (prefabOptional.isPresent()) {
            return prefabOptional.get();
        }
        throw new RuntimeException("Prefab " + path + " not found!");
    }

    public static OggSound getSound(String path) {
        Optional<OggSound> oggSoundOptional = assetHelper.get(new ResourceUrn(path), OggSound.class);
        if (oggSoundOptional.isPresent()) {
            return oggSoundOptional.get();
        }
        throw new RuntimeException("OggSound " + path + " not found!");
    }

    public static OggMusic getMusic(String path) {
        Optional<OggMusic> oggMusicOptional = assetHelper.get(new ResourceUrn(path), OggMusic.class);
        if (oggMusicOptional.isPresent()) {
            return oggMusicOptional.get();
        }
        throw new RuntimeException("OggMusic " + path + " not found!");
    }

    public static Font getFont(String path) {
        Optional<Font> fontOptional = assetHelper.get(new ResourceUrn(path), Font.class);
        if (fontOptional.isPresent()) {
            return fontOptional.get();
        }
        throw new RuntimeException("Font " + path + " not found!");
    }

    public static Emitter getEmitter(String path) {
        Optional<Emitter> emitterOptional = assetHelper.get(new ResourceUrn(path), Emitter.class);
        if (emitterOptional.isPresent()) {
            return emitterOptional.get();
        }
        throw new RuntimeException("Emitter " + path + " not found!");
    }

    public static Json getJson(String path) {
        Optional<Json> jsonOptional = assetHelper.get(new ResourceUrn(path), Json.class);
        if (jsonOptional.isPresent()) {
            return jsonOptional.get();
        }
        throw new RuntimeException("Json " + path + " not found!");
    }

    public static DSTexture getDSTexture(String path) {
        Optional<DSTexture> dsTextureOptional = assetHelper.get(new ResourceUrn(path), DSTexture.class);
        if (dsTextureOptional.isPresent()) {
            return dsTextureOptional.get();
        }
        throw new RuntimeException("DSTexture " + path + " not found!");
    }

    public static TextureAtlas.AtlasRegion getAtlasRegion(String path, Texture.TextureFilter textureFilter) {
        String sanitisedPath = path;
        if (path.contains("/")) {
            sanitisedPath = path.replace(path.substring(path.indexOf(58) + 1, path.lastIndexOf(47) + 1), "");
        }
        Texture texture = Assets.getDSTexture(sanitisedPath).getTexture();
        texture.setFilter(textureFilter, textureFilter);
        TextureAtlas.AtlasRegion atlasRegion = new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
        atlasRegion.flip(false, true);
        atlasRegion.name = path;
        return atlasRegion;
    }

    public static TextureAtlas.AtlasRegion getAtlasRegion(String path) {
        return Assets.getAtlasRegion(path, Texture.TextureFilter.Nearest);
    }

    public static Animation<TextureAtlas.AtlasRegion> getAnimation(String texturePath) {
        if (!assetHelper.get(new ResourceUrn(texturePath), DSTexture.class).isPresent()) {
            return null;
        }
        String animationPath = texturePath + "Animation";
        if (!assetHelper.get(new ResourceUrn(animationPath), DSTexture.class).isPresent()) {
            return new Animation(Float.MAX_VALUE, (Object[])new TextureAtlas.AtlasRegion[]{Assets.getAtlasRegion(texturePath)});
        }
        Texture originalTexture = Assets.getDSTexture(texturePath).getTexture();
        Json animationInfoJson = Assets.getJson(animationPath);
        JSONObject animationInfo = animationInfoJson.getJsonValue();
        int frameWidth = animationInfo.optInt("frameWidth", 256);
        int frameHeight = animationInfo.optInt("frameHeight", 256);
        int frameCount = animationInfo.optInt("frameCount", 1);
        float framesPerSecond = (float)animationInfo.optDouble("framesPerSecond", 24.0);
        boolean autoGenerateFrames = animationInfo.optBoolean("autoGenerateFrames", false);
        Object[] frames = new TextureAtlas.AtlasRegion[frameCount];
        if (autoGenerateFrames) {
            frameCount = originalTexture.getWidth() / frameWidth * (originalTexture.getHeight() / frameHeight);
            TextureAtlas.AtlasRegion region = new TextureAtlas.AtlasRegion(originalTexture, 0, 0, frameWidth, frameHeight);
            region.name = texturePath;
            frames = SpriteManager.getSequentialRegions(region, frameCount, frameWidth, frameHeight);
        } else {
            ArrayList<TextureAtlas.AtlasRegion> regions = new ArrayList<TextureAtlas.AtlasRegion>();
            JSONArray framesArray = animationInfo.optJSONArray("frames");
            if (framesArray != null) {
                for (int frame = 0; frame < framesArray.length(); ++frame) {
                    JSONObject frameObject = framesArray.getJSONObject(frame);
                    int x = frameObject.optInt("x", 0);
                    int y = frameObject.optInt("y", 0);
                    int regionWidth = frameObject.optInt("width", frameWidth);
                    int regionHeight = frameObject.optInt("height", frameHeight);
                    TextureAtlas.AtlasRegion region = new TextureAtlas.AtlasRegion(originalTexture, x, y, regionWidth, regionHeight);
                    region.flip(false, true);
                    region.name = texturePath + " frame " + frame;
                    regions.add(region);
                }
            }
            frames = regions.toArray(frames);
        }
        animationInfoJson.dispose();
        Animation animation = new Animation(1.0f / framesPerSecond, frames);
        return animation;
    }

    public static void cacheLists() {
        textureList = assetHelper.list(DSTexture.class);
    }

    public static void uncacheLists() {
        textureList.clear();
        textureList = null;
    }

    public static List<TextureAtlas.AtlasRegion> listTexturesMatching(String regex) {
        boolean listsCached = true;
        if (textureList == null) {
            listsCached = false;
            Assets.cacheLists();
        }
        ArrayList<TextureAtlas.AtlasRegion> textures = new ArrayList<TextureAtlas.AtlasRegion>();
        for (ResourceUrn resourceUrn : textureList) {
            if (!resourceUrn.toString().matches(regex)) continue;
            textures.add(Assets.getAtlasRegion(resourceUrn.toString()));
        }
        if (!listsCached) {
            Assets.uncacheLists();
        }
        return textures;
    }

    public static ArrayList<String> convertToStringList(JSONArray arr) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr.length(); ++i) {
            list.add(arr.getString(i));
        }
        return list;
    }

    static {
        logger = LoggerFactory.getLogger(Assets.class);
    }
}

