/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.fonts;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.io.IOException;
import java.util.List;
import org.destinationsol.assets.AssetDataFileHandle;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.fonts.FontData;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.AbstractAssetFileFormat;
import org.terasology.gestalt.assets.format.AssetDataFile;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetFileFormat;

@RegisterAssetFileFormat
public class FontFileFormat
extends AbstractAssetFileFormat<FontData> {
    public FontFileFormat() {
        super("font", new String[0]);
    }

    public FontData load(ResourceUrn urn, List<AssetDataFile> inputs) throws IOException {
        AssetDataFileHandle fontDataHandle = new AssetDataFileHandle(inputs.get(0));
        BitmapFont.BitmapFontData fontData = new BitmapFont.BitmapFontData((FileHandle)fontDataHandle, true);
        String[] fontTexturePath = fontData.imagePaths[0].split("/");
        String fontTextureName = fontTexturePath[fontTexturePath.length - 1];
        fontTextureName = fontTextureName.substring(0, fontTextureName.lastIndexOf(46));
        TextureRegion fontTexture = new TextureRegion(Assets.getDSTexture(urn.getModuleName() + ":" + fontTextureName).getTexture());
        BitmapFont bitmapFont = new BitmapFont(fontData, fontTexture, false);
        bitmapFont.setUseIntegerPositions(false);
        return new FontData(bitmapFont);
    }
}

