/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.json;

import java.io.IOException;
import org.destinationsol.assets.AssetDataFileHandle;
import org.destinationsol.assets.json.JsonData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.terasology.gestalt.assets.format.AbstractAssetAlterationFileFormat;
import org.terasology.gestalt.assets.format.AssetDataFile;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetDeltaFileFormat;

@RegisterAssetDeltaFileFormat
public class JsonDeltaFileFormat
extends AbstractAssetAlterationFileFormat<JsonData> {
    public JsonDeltaFileFormat() {
        super("json", new String[0]);
    }

    public void apply(AssetDataFile input, JsonData assetData) throws IOException {
        AssetDataFileHandle handle = new AssetDataFileHandle(input);
        JSONObject deltaJsonValue = new JSONObject(handle.readString());
        JSONObject jsonValue = assetData.getJsonValue();
        this.mergeObjects(jsonValue, deltaJsonValue);
    }

    private void mergeObjects(JSONObject input, JSONObject delta) {
        for (String key : input.keySet()) {
            Object deltaObject;
            Object subObject = input.get(key);
            if (!delta.has(key)) continue;
            if (subObject instanceof JSONObject) {
                deltaObject = delta.get(key);
                if (deltaObject instanceof JSONObject) {
                    this.mergeObjects((JSONObject)subObject, (JSONObject)deltaObject);
                    continue;
                }
                throw new JSONException("Error when parsing delta: Type " + deltaObject.getClass().getSimpleName() + " does not equal JSONObject");
            }
            if (subObject instanceof JSONArray) {
                deltaObject = delta.get(key);
                if (deltaObject instanceof JSONArray) {
                    this.mergeArray((JSONArray)subObject, (JSONArray)deltaObject);
                    continue;
                }
                throw new JSONException("Error when parsing delta: Type " + deltaObject.getClass().getSimpleName() + " does not equal JSONArray");
            }
            input.put(key, delta.get(key));
        }
    }

    private void mergeArray(JSONArray input, JSONArray delta) {
        for (int index = 0; index < delta.length(); ++index) {
            input.put(delta.get(index));
        }
    }
}

