/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.json;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.common.SolException;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    static Logger logger = LoggerFactory.getLogger(Validator.class);

    public static JSONObject getValidatedJSON(String jsonPath, String schemaPath) {
        JSONObject schema;
        Json json = Assets.getJson(jsonPath);
        JSONObject jsonObject = json.getJsonValue();
        try {
            schema = Assets.getJson(schemaPath).getJsonValue();
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("Json " + schemaPath + " not found!")) {
                logger.warn("Json Schema " + schemaPath + " not found!");
                json.dispose();
                return jsonObject;
            }
            throw e;
        }
        if (Gdx.app.getType() != Application.ApplicationType.Android) {
            Schema schemaValidator = SchemaLoader.load((JSONObject)schema);
            try {
                schemaValidator.validate((Object)jsonObject);
            }
            catch (ValidationException e) {
                throw new SolException("JSON \"" + jsonPath + "\" could not be validated against schema \"" + schemaPath + "\"." + e.getErrorMessage());
            }
        }
        json.dispose();
        return jsonObject;
    }
}

