/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.music;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MusicConfig {
    public final String moduleName;
    public final Map<String, List<String>> musicMap;

    public MusicConfig(String moduleName, Map<String, List<String>> musicMap) {
        this.moduleName = moduleName;
        this.musicMap = musicMap;
    }

    static MusicConfig load(String moduleName, JSONObject config) {
        Object musicFileName;
        int index;
        ArrayList<String> menuMusicSet = new ArrayList<String>();
        ArrayList<String> gameMusicSet = new ArrayList<String>();
        JSONArray menuMusicArray = config.getJSONArray("menuMusic");
        JSONArray gameMusicArray = config.getJSONArray("gameMusic");
        for (index = 0; index < menuMusicArray.length(); ++index) {
            musicFileName = menuMusicArray.get(index);
            if (!(musicFileName instanceof String)) continue;
            menuMusicSet.add(moduleName + ":" + musicFileName);
        }
        for (index = 0; index < gameMusicArray.length(); ++index) {
            musicFileName = gameMusicArray.get(index);
            if (!(musicFileName instanceof String)) continue;
            gameMusicSet.add(moduleName + ":" + musicFileName);
        }
        HashMap<String, List<String>> musicMap = new HashMap<String, List<String>>();
        musicMap.put("menu", menuMusicSet);
        musicMap.put("game", gameMusicSet);
        return new MusicConfig(moduleName, musicMap);
    }

    public Map<String, List<String>> getMusicMap() {
        return this.musicMap;
    }
}

