/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.music;

import com.badlogic.gdx.audio.Music;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.destinationsol.GameOptions;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.music.MusicConfig;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;

public class OggMusicManager {
    public static final String NO_MUSIC = "";
    public static final String MENU_MUSIC_SET = "menu";
    public static final String GAME_MUSIC_SET = "game";
    private final Map<String, List<Music>> musicMap;
    private Music currentlyPlaying;
    private String currentlyRegisteredModule;
    private String currentMusicSet = "";
    private Logger logger = LoggerFactory.getLogger(OggMusicManager.class);

    public OggMusicManager(GameOptions options) {
        this.musicMap = new HashMap<String, List<Music>>();
        this.registerMusic(GAME_MUSIC_SET, "engine:cimmerianDawn");
        this.registerMusic(GAME_MUSIC_SET, "engine:intoTheDark");
        this.registerMusic(GAME_MUSIC_SET, "engine:spaceTheatre");
        this.registerAllMenuMusic(options);
    }

    public void registerMusic(String musicSet, String music) {
        this.registerMusic(musicSet, Assets.getMusic(music).getMusic());
    }

    public void registerMusic(String musicSet, Music music) {
        if (!this.musicMap.containsKey(musicSet)) {
            this.musicMap.put(musicSet, new ArrayList());
        }
        this.musicMap.get(musicSet).add(music);
    }

    public void playMusic(String musicSet, GameOptions options) {
        this.stopMusic();
        if (this.musicMap.get(musicSet).isEmpty()) {
            return;
        }
        int index = 0;
        if (this.currentlyPlaying != null && this.musicMap.get(musicSet).contains(this.currentlyPlaying)) {
            index = this.musicMap.get(musicSet).indexOf(this.currentlyPlaying);
            if (++index + 1 > this.musicMap.get(musicSet).size()) {
                index = 0;
            }
        }
        this.currentMusicSet = musicSet;
        Music music = this.musicMap.get(musicSet).get(index);
        music.setOnCompletionListener(a -> this.playMusic(musicSet, options));
        this.playMusicTrack(music, options);
    }

    private void playMusicTrack(Music music, GameOptions options) {
        this.currentlyPlaying = music;
        this.currentlyPlaying.setVolume(options.musicVolume.getVolume());
        this.currentlyPlaying.play();
    }

    private void stopMusic() {
        if (this.currentlyPlaying != null) {
            this.currentlyPlaying.stop();
        }
        this.currentMusicSet = NO_MUSIC;
    }

    public void changeVolume(GameOptions options) {
        this.currentlyPlaying.setVolume(options.musicVolume.getVolume());
    }

    public void registerModuleMusic(String moduleName, GameOptions options) {
        if (this.currentlyRegisteredModule != null) {
            if (moduleName.equals(this.currentlyRegisteredModule)) {
                this.stopMusic();
                this.playMusicTrack(this.musicMap.get(GAME_MUSIC_SET).get(2), options);
                return;
            }
            this.unregisterModuleMusic();
            this.currentlyRegisteredModule = null;
        }
        if (!Assets.getAssetHelper().get(new ResourceUrn(moduleName + ":musicConfig"), Json.class).isPresent()) {
            return;
        }
        this.logger.info("Music Config found for module " + moduleName);
        Json musicJson = Assets.getJson(moduleName + ":musicConfig");
        MusicConfig musicConfig = MusicConfig.load(moduleName, musicJson.getJsonValue());
        Map<String, List<String>> musicSets = musicConfig.getMusicMap();
        for (String music : musicSets.get(GAME_MUSIC_SET)) {
            this.registerMusic(GAME_MUSIC_SET, music);
            this.logger.info("Registered " + music);
        }
        this.currentlyRegisteredModule = moduleName;
        this.stopMusic();
        this.playMusicTrack(this.musicMap.get(GAME_MUSIC_SET).get(2), options);
    }

    public void registerAllMenuMusic(GameOptions options) {
        Set<ResourceUrn> configUrnList = Assets.getAssetHelper().listAssets(Json.class, "musicConfig");
        for (ResourceUrn configUrn : configUrnList) {
            Object musicFileName;
            String urnString = configUrn.toString();
            Json musicJson = Assets.getJson(urnString);
            JSONObject musicNode = musicJson.getJsonValue();
            JSONArray array = musicNode.getJSONArray("menuMusic");
            for (int index = 0; index < array.length() && (musicFileName = array.get(index)) instanceof String; ++index) {
                String music = (String)musicFileName;
                this.registerMusic(MENU_MUSIC_SET, urnString.split(":")[0] + ":" + music);
            }
        }
        this.registerMusic(MENU_MUSIC_SET, "engine:dreadnaught");
        this.playMusicTrack(this.musicMap.get(MENU_MUSIC_SET).get(0), options);
    }

    public void unregisterModuleMusic() {
        this.musicMap.get(GAME_MUSIC_SET).clear();
        this.registerMusic(GAME_MUSIC_SET, "engine:cimmerianDawn");
        this.registerMusic(GAME_MUSIC_SET, "engine:intoTheDark");
        this.registerMusic(GAME_MUSIC_SET, "engine:spaceTheatre");
    }

    public void resetMusic() {
        this.musicMap.put(GAME_MUSIC_SET, new ArrayList());
    }

    public String getCurrentMusicSet() {
        return this.currentMusicSet;
    }
}

