/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.sound;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.destinationsol.assets.sound.OggSoundData;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.AbstractAssetFileFormat;
import org.terasology.gestalt.assets.format.AssetDataFile;

public class AndroidOggSoundFileFormat
extends AbstractAssetFileFormat<OggSoundData> {
    public AndroidOggSoundFileFormat() {
        super("ogg", new String[0]);
    }

    public OggSoundData load(ResourceUrn urn, List<AssetDataFile> inputs) throws IOException {
        AssetDataFile asset = inputs.get(0);
        FileHandle outFile = Gdx.files.local("sound/" + urn.toString().replace(":", "_") + "." + inputs.get(0).getFileExtension());
        if (!outFile.exists()) {
            InputStream fileStream = asset.openStream();
            outFile.write(fileStream, false);
        }
        return new OggSoundData(Gdx.audio.newSound(outFile));
    }
}

