/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.sound;

import com.badlogic.gdx.audio.Sound;
import org.destinationsol.assets.sound.OggSoundData;
import org.destinationsol.assets.sound.OggSoundFactory;
import org.destinationsol.assets.sound.PlayableSound;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.module.annotations.RegisterAssetType;

@RegisterAssetType(folderName={"sounds"}, factoryClass=OggSoundFactory.class)
public class OggSound
extends Asset<OggSoundData>
implements PlayableSound {
    private OggSoundData soundData;

    public OggSound(ResourceUrn urn, AssetType<?, OggSoundData> assetType, OggSoundData data) {
        super(urn, assetType);
        this.reload(data);
    }

    protected void doReload(OggSoundData data) {
        this.soundData = data;
    }

    @Override
    public OggSound getOggSound() {
        return this;
    }

    @Override
    public float getBasePitch() {
        return this.soundData.getBasePitch();
    }

    public void setBasePitch(float basePitch) {
        this.soundData.setBasePitch(basePitch);
    }

    public float getLoopTime() {
        return this.soundData.getLoopTime();
    }

    public float getBaseVolume() {
        return this.soundData.getBaseVolume();
    }

    public Sound getSound() {
        return this.soundData.getSound();
    }

    public void doDispose() {
        this.soundData.dispose();
    }

    public String toString() {
        return String.format("[%s] baseVolume: %s loopTime: %s", this.getUrn(), Float.valueOf(this.soundData.getBaseVolume()), Float.valueOf(this.soundData.getLoopTime()));
    }
}

