/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.assets.sound;

import com.badlogic.gdx.math.Vector2;
import java.util.Arrays;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.OggSoundSet;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;

public class SpecialSounds {
    public final PlayableSound metalColl;
    public final PlayableSound metalEnergyHit;
    public final PlayableSound rockColl;
    public final PlayableSound rockEnergyHit;
    public final PlayableSound asteroidCrack;
    public final PlayableSound shipExplosion;
    public final PlayableSound forceBeaconWork;
    public final PlayableSound doorMove;
    public final PlayableSound abilityRecharged;
    public final PlayableSound abilityRefused;
    public final PlayableSound controlDisabled;
    public final PlayableSound controlEnabled;
    public final PlayableSound lootThrow;
    public final PlayableSound transcendentCreated;
    public final PlayableSound transcendentFinished;
    public final PlayableSound metalBulletHit;
    public final PlayableSound rockBulletHit;
    public final PlayableSound burning;
    public final PlayableSound transcendentMove;

    public SpecialSounds(OggSoundManager soundManager) {
        this.metalColl = soundManager.getSound("core:metalCollision");
        this.metalEnergyHit = soundManager.getSound("core:empty");
        this.rockColl = soundManager.getSound("core:rockCollision");
        this.rockEnergyHit = soundManager.getSound("core:empty");
        this.asteroidCrack = soundManager.getSound("core:asteroidCrack");
        this.shipExplosion = soundManager.getSound("core:shipExplosion");
        this.forceBeaconWork = soundManager.getSound("core:forceBeaconWork");
        this.doorMove = soundManager.getSound("core:controlEnabled");
        this.abilityRecharged = soundManager.getSound("core:abilityRecharged");
        this.abilityRefused = soundManager.getSound("core:abilityRefused");
        this.controlDisabled = soundManager.getSound("core:controlDisabled");
        this.controlEnabled = soundManager.getSound("core:controlEnabled");
        this.lootThrow = soundManager.getSound("core:rocketLauncherShoot");
        this.transcendentCreated = soundManager.getSound("core:teleport");
        this.transcendentFinished = soundManager.getSound("core:teleport");
        this.metalBulletHit = new OggSoundSet(soundManager, Arrays.asList("core:metalBulletHit0", "core:metalBulletHit1", "core:metalBulletHit2"), 1.1f);
        this.rockBulletHit = new OggSoundSet(soundManager, Arrays.asList("core:rockBulletHit0", "core:rockBulletHit1"));
        this.burning = new OggSoundSet(soundManager, Arrays.asList("core:burning2", "core:burning3", "core:burning4"));
        this.transcendentMove = new OggSoundSet(soundManager, Arrays.asList("core:transcendentMove", "core:transcendentMove2", "core:transcendentMove3", "core:transcendentMove4"));
    }

    public PlayableSound hitSound(boolean forMetal, DmgType dmgType) {
        if (dmgType == DmgType.ENERGY) {
            return forMetal ? this.metalEnergyHit : this.rockEnergyHit;
        }
        if (dmgType == DmgType.BULLET) {
            return forMetal ? this.metalBulletHit : this.rockBulletHit;
        }
        return null;
    }

    public void playHit(SolGame game, SolObject o, Vector2 position, DmgType dmgType) {
        if (o == null) {
            return;
        }
        Boolean metal = o.isMetal();
        if (metal == null) {
            return;
        }
        PlayableSound sound = this.hitSound(metal, dmgType);
        if (sound == null) {
            return;
        }
        game.getSoundManager().play(game, sound, position, o);
    }

    public void playColl(SolGame game, float absImpulse, SolObject o, Vector2 position) {
        if (o == null || absImpulse < 0.1f) {
            return;
        }
        Boolean metal = o.isMetal();
        if (metal == null) {
            return;
        }
        game.getSoundManager().play(game, metal != false ? this.metalColl : this.rockColl, position, o, absImpulse * 2.0f);
    }
}

