/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.common;

import com.badlogic.gdx.graphics.Color;

public class SolColorUtil {
    public static void fromHSB(float hue, float saturation, float brightness, float a, Color dest) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (saturation == 0.0f) {
            g = b = brightness;
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        dest.r = r;
        dest.g = g;
        dest.b = b;
        dest.a = a;
    }

    public static float[] toHSB(Color src) {
        float hue;
        int cmin;
        int cmax;
        int r = (int)(src.r * 255.0f + 0.5f);
        int g = (int)(src.g * 255.0f + 0.5f);
        int b = (int)(src.b * 255.0f + 0.5f);
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] hsba = new float[]{hue, saturation, brightness, src.a};
        return hsba;
    }

    public static Color load(String s) {
        String[] parts = s.split(" ");
        boolean hsb = "hsb".equals(parts[0]);
        int idx = hsb ? 1 : 0;
        int v1 = Integer.parseInt(parts[idx++]);
        int v2 = Integer.parseInt(parts[idx++]);
        int v3 = Integer.parseInt(parts[idx++]);
        float a = 1.0f;
        if (parts.length > idx) {
            a = (float)Integer.parseInt(parts[idx]) / 255.0f;
        }
        Color res = new Color();
        if (hsb) {
            SolColorUtil.fromHSB((float)v1 / 360.0f, (float)v2 / 100.0f, (float)v3 / 100.0f, a, res);
        } else {
            res.set((float)v1 / 255.0f, (float)v2 / 255.0f, (float)v3 / 255.0f, a);
        }
        return res;
    }

    public static void changeBrightness(Color c, float b) {
        if (b > 0.0f) {
            float bi = 1.0f - b;
            c.r = 1.0f - bi * (1.0f - c.r);
            c.g = 1.0f - bi * (1.0f - c.g);
            c.b = 1.0f - bi * (1.0f - c.b);
            return;
        }
        float bi = 1.0f + b;
        c.r *= bi;
        c.g *= bi;
        c.b *= bi;
    }
}

