/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.common;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import org.destinationsol.common.Bound;
import org.json.JSONArray;
import org.json.JSONObject;

public class SolMath {
    private static Pool<Vector2> vectorPool = new Pool<Vector2>(){

        protected Vector2 newObject() {
            return new Vector2();
        }
    };
    private static int vectorsTaken;

    public static int toInt(boolean b) {
        return b ? 1 : -1;
    }

    public static float abs(float a) {
        return a < 0.0f ? -a : a;
    }

    public static float approach(float src, float dst, float speed) {
        if (dst - speed <= src && src <= dst + speed) {
            return dst;
        }
        return src < dst ? src + speed : src - speed;
    }

    public static float approachAngle(float src, float dst, float speed) {
        if (SolMath.angleDiff(src, dst) <= speed) {
            return dst;
        }
        float diff = SolMath.norm(dst - src);
        return SolMath.norm(diff > 0.0f ? src + speed : src - speed);
    }

    public static float norm(float a) {
        if (a != a) {
            throw new AssertionError((Object)"normalizing NaN angle");
        }
        while (a <= -180.0f) {
            a += 360.0f;
        }
        while (a > 180.0f) {
            a -= 360.0f;
        }
        return a;
    }

    public static float clamp(float val) {
        return MathUtils.clamp((float)val, (float)0.0f, (float)1.0f);
    }

    public static void fromAl(Vector2 vec, float angle, float len) {
        vec.set(len, 0.0f);
        SolMath.rotate(vec, angle);
    }

    @Bound
    public static Vector2 fromAl(float angle, float len) {
        Vector2 vec = SolMath.getVec();
        SolMath.fromAl(vec, angle, len);
        return vec;
    }

    @Bound
    public static Vector2 getVec(Vector2 src) {
        return SolMath.getVec(src.x, src.y);
    }

    @Bound
    public static Vector2 getVec(float x, float y) {
        ++vectorsTaken;
        Vector2 v = (Vector2)vectorPool.obtain();
        v.set(x, y);
        return v;
    }

    public static void free(Vector2 v) {
        --vectorsTaken;
        vectorPool.free((Object)v);
    }

    @Bound
    public static Vector2 getVec() {
        return SolMath.getVec(0.0f, 0.0f);
    }

    public static void checkVectorsTaken(Object o) {
        if (vectorsTaken != 0) {
            throw new AssertionError((Object)("vectors " + vectorsTaken + ", blame on " + o));
        }
    }

    @Bound
    public static Vector2 toWorld(Vector2 relPos, float baseAngle, Vector2 basePos) {
        Vector2 v = SolMath.getVec();
        SolMath.toWorld(v, relPos, baseAngle, basePos);
        return v;
    }

    public static void toWorld(Vector2 position, Vector2 relPos, float baseAngle, Vector2 basePos) {
        position.set(relPos);
        SolMath.rotate(position, baseAngle);
        position.add(basePos);
    }

    @Bound
    public static Vector2 toRel(Vector2 position, float baseAngle, Vector2 basePos) {
        Vector2 v = SolMath.getVec();
        SolMath.toRel(position, v, baseAngle, basePos);
        return v;
    }

    public static void toRel(Vector2 position, Vector2 relPos, float baseAngle, Vector2 basePos) {
        relPos.set(position);
        relPos.sub(basePos);
        SolMath.rotate(relPos, -baseAngle);
    }

    public static void rotate(Vector2 v, float angle) {
        v.rotate(angle);
    }

    @Bound
    public static Vector2 distVec(Vector2 from, Vector2 to) {
        Vector2 v = SolMath.getVec(to);
        v.sub(from);
        return v;
    }

    public static float project(Vector2 v, float angle) {
        float angleDiff = angle - SolMath.angle(v);
        return v.len() * MathUtils.cosDeg((float)angleDiff);
    }

    public static void assetReal(Vector2 ... vectors) {
        for (Vector2 vector : vectors) {
            if (Double.isNaN(vector.x) || Double.isNaN(vector.y)) {
                throw new AssertionError((Object)("Vector is not valid: " + vector.x + " " + vector.y));
            }
        }
    }

    public static float sqrt(float v) {
        return (float)Math.sqrt(v);
    }

    public static float angle(Vector2 from, Vector2 to) {
        Vector2 tmp = SolMath.distVec(from, to);
        float angle = SolMath.angle(tmp);
        SolMath.free(tmp);
        return angle;
    }

    public static float angle(Vector2 v) {
        return SolMath.norm(MathUtils.atan2((float)v.y, (float)v.x) * 57.295776f);
    }

    public static float arcSin(float val) {
        return (float)Math.asin(val) * 57.295776f;
    }

    public static float angularWidthOfSphere(float radius, float dist) {
        return SolMath.arcSin(radius / dist);
    }

    public static float arcToAngle(float hordeLen, float radius) {
        return 57.295776f * hordeLen / radius;
    }

    public static float hypotenuse(float a, float b) {
        return SolMath.sqrt(a * a + b * b);
    }

    public static float windowCenter(float val, float window) {
        float winNr = (int)(val / window);
        return (winNr += 0.5f * (float)SolMath.toInt(val > 0.0f)) * window;
    }

    public static boolean isAngleBetween(float a, float b, float x) {
        if (a <= b) {
            return a <= x && x < b;
        }
        return a <= x || x < b;
    }

    public static float angleDiff(float a, float b) {
        return SolMath.abs(SolMath.norm(a - b));
    }

    public static float angleToArc(float angle, float r) {
        return angle * ((float)Math.PI / 180) * r;
    }

    public static float genQuad(float a, float b, float c) {
        if (a == 0.0f) {
            return SolMath.genLin(b, c);
        }
        float disc = b * b - 4.0f * a * c;
        if (disc < 0.0f) {
            return Float.NaN;
        }
        if (disc == 0.0f) {
            return -b / 2.0f / a;
        }
        float dsq = SolMath.sqrt(disc);
        float x1 = (-b - dsq) / 2.0f / a;
        float x2 = (-b + dsq) / 2.0f / a;
        if (x1 < 0.0f) {
            return x2 < 0.0f ? Float.NaN : x2;
        }
        if (x2 < 0.0f) {
            return x1;
        }
        return Math.min(x1, x2);
    }

    public static float genLin(float b, float c) {
        if (b == 0.0f) {
            return c == 0.0f ? 0.0f : Float.NaN;
        }
        float res = -c / b;
        return res < 0.0f ? Float.NaN : res;
    }

    public static Vector2 readV2(JSONObject v, String name) {
        return SolMath.readV2(v.getString(name));
    }

    public static Vector2 readV2(String encoded) {
        String[] parts = encoded.split(" ");
        float x = Float.parseFloat(parts[0]);
        float y = Float.parseFloat(parts[1]);
        return new Vector2(x, y);
    }

    public static ArrayList<Vector2> readV2List(JSONObject parentNode, String name) {
        JSONArray listNode;
        ArrayList<Vector2> res = new ArrayList<Vector2>();
        JSONArray jSONArray = listNode = parentNode.has(name) ? parentNode.getJSONArray(name) : null;
        if (listNode == null) {
            return res;
        }
        for (int index = 0; index < listNode.length(); ++index) {
            Object val = listNode.get(index);
            if (!(val instanceof String)) continue;
            Vector2 vec = SolMath.readV2((String)val);
            res.add(vec);
        }
        return res;
    }

    public static boolean canAccelerate(float accAngle, Vector2 velocity) {
        return velocity.len() < 8.0f || SolMath.angleDiff(SolMath.angle(velocity), accAngle) > 90.0f;
    }

    public static String nice(float v) {
        int i = (int)(v * 10.0f);
        int whole = i / 10;
        int dec = i - 10 * whole;
        if (dec < 0) {
            dec = -dec;
        }
        return whole + "." + dec;
    }
}

