/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.common;

import com.badlogic.gdx.Gdx;
import java.util.List;
import java.util.Random;

public class SolRandom {
    private static long seed;
    private static Random seededRandom;
    private static Random random;

    public static float seededRandomFloat(float minMax) {
        return SolRandom.seededRandomFloat(-minMax, minMax);
    }

    public static float seededRandomFloat(float min, float max) {
        if (min >= max) {
            Gdx.app.log("SolMath", "seededRandomFloat was called with bad parameters! Min " + min + " >= max " + max + ".");
            Gdx.app.log("SolMath", "Please review appropriate code in the stack dump:");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                Gdx.app.log("SolMath", stackTraceElement.toString());
            }
            return max;
        }
        return seededRandom.nextFloat() * (max - min) + min;
    }

    public static int seededRandomInt(int max) {
        return SolRandom.seededRandomInt(0, max);
    }

    public static int seededRandomInt(float percentage, int max) {
        int min = (int)((float)max * percentage);
        if (min == max) {
            throw new AssertionError((Object)("seededRandomInt min equals max " + min));
        }
        return seededRandom.nextInt(max - min) + min;
    }

    public static int seededRandomInt(int min, int max) {
        return seededRandom.nextInt(max - min) + min;
    }

    public static float randomFloat(float minMax) {
        return SolRandom.randomFloat(-minMax, minMax);
    }

    public static float randomFloat(float min, float max) {
        float result = max;
        if (min == max) {
            Gdx.app.log("SolMath", "randomFloat was called with bad parameters! Min " + min + " matches max " + max + ", accepting max.");
            Gdx.app.log("SolMath", "Please review appropriate code in the stack dump:");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                Gdx.app.log("SolMath", stackTraceElement.toString());
            }
            return result;
        }
        return random.nextFloat() * (max - min) + min;
    }

    public static int randomInt(int max) {
        return SolRandom.randomInt(0, max);
    }

    public static int randomInt(float percentage, int max) {
        int min = (int)((float)max * percentage);
        if (min == max) {
            throw new AssertionError((Object)("randomInt min equals max " + min));
        }
        return random.nextInt(max - min) + min;
    }

    public static int randomInt(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static <T> T randomElement(List<T> list) {
        int index = SolRandom.randomInt(list.size());
        return list.get(index);
    }

    public static <T> T seededRandomElement(List<T> list) {
        int index = SolRandom.seededRandomInt(list.size());
        return list.get(index);
    }

    public static void setSeed(long seed) {
        SolRandom.seed = seed;
        seededRandom = new Random(seed);
    }

    public static long getSeed() {
        return seed;
    }

    public static boolean test(float value) {
        return SolRandom.randomFloat(0.0f, 1.0f) < value;
    }

    public static boolean seededTest(float value) {
        return SolRandom.seededRandomFloat(0.0f, 1.0f) < value;
    }

    static {
        seededRandom = new Random(seed);
        random = new Random();
    }
}

