/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.entitysystem;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.destinationsol.entitysystem.ComponentSystem;
import org.destinationsol.game.context.Context;
import org.destinationsol.util.InjectionHelper;
import org.terasology.gestalt.module.ModuleEnvironment;

public class ComponentSystemManager {
    private ArrayList<ComponentSystem> componentSystems = Lists.newArrayList();

    public ComponentSystemManager(ModuleEnvironment environment, Context context) {
        for (Class componentSystem : environment.getSubtypesOf(ComponentSystem.class)) {
            try {
                ComponentSystem system = (ComponentSystem)componentSystem.newInstance();
                InjectionHelper.inject(system, context);
                this.componentSystems.add(system);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void preBegin() {
        this.componentSystems.forEach(ComponentSystem::preBegin);
    }
}

