/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.entitysystem;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.destinationsol.entitysystem.EventReceiver;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentManager;
import org.terasology.gestalt.entitysystem.component.store.ArrayComponentStore;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;
import org.terasology.gestalt.entitysystem.component.store.ConcurrentComponentStore;
import org.terasology.gestalt.entitysystem.entity.EntityIterator;
import org.terasology.gestalt.entitysystem.entity.EntityManager;
import org.terasology.gestalt.entitysystem.entity.manager.CoreEntityManager;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventSystem;
import org.terasology.gestalt.entitysystem.event.impl.EventReceiverMethodSupport;
import org.terasology.gestalt.entitysystem.event.impl.EventSystemImpl;
import org.terasology.gestalt.entitysystem.prefab.GeneratedFromRecipeComponent;
import org.terasology.gestalt.module.ModuleEnvironment;

public class EntitySystemManager {
    private static EntityManager entityManager;
    private EventSystem eventSystem = new EventSystemImpl();
    private static EventReceiverMethodSupport eventReceiverMethodSupport;

    public EntitySystemManager(ModuleEnvironment environment, ComponentManager componentManager) {
        ArrayList stores = Lists.newArrayList();
        for (Class componentType : environment.getSubtypesOf(Component.class)) {
            stores.add(new ConcurrentComponentStore((ComponentStore)new ArrayComponentStore(componentManager.getType(componentType))));
        }
        stores.add(new ConcurrentComponentStore((ComponentStore)new ArrayComponentStore(componentManager.getType(GeneratedFromRecipeComponent.class))));
        entityManager = new CoreEntityManager((Collection)stores);
        for (Class eventReceiver : environment.getSubtypesOf(EventReceiver.class)) {
            try {
                eventReceiverMethodSupport.register(eventReceiver.newInstance(), this.eventSystem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendEvent(Event event, Component ... components) {
        EntityIterator iterator = entityManager.iterate(components);
        while (iterator.next()) {
            this.eventSystem.send(event, iterator.getEntity());
        }
        this.eventSystem.processEvents();
    }

    public EntityManager getEntityManager() {
        return entityManager;
    }

    static {
        eventReceiverMethodSupport = new EventReceiverMethodSupport();
    }
}

