/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.entitysystem;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.destinationsol.protobuf.EntityData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityManager;
import org.terasology.gestalt.entitysystem.entity.EntityRef;

public final class SerialisationManager {
    private static final Logger logger = LoggerFactory.getLogger(SerialisationManager.class);
    private File file;
    private EntityManager entityManager;
    private ClassLoader classLoader;

    public SerialisationManager(String path, EntityManager entityManager, ClassLoader classLoader) {
        this.file = new File(path);
        this.entityManager = entityManager;
        this.classLoader = classLoader;
    }

    public void serialise() throws IllegalArgumentException, IllegalAccessException, IOException {
        EntityRef entity;
        EntityData.EntityStore.Builder storeBuilder = EntityData.EntityStore.newBuilder();
        Iterator iterator = this.entityManager.allEntities().iterator();
        while (iterator.hasNext() && (entity = (EntityRef)iterator.next()).getId() != -1) {
            EntityData.Entity.Builder entityBuilder = EntityData.Entity.newBuilder();
            entityBuilder.setId(entity.getId());
            for (Component component : entity.getAllComponents().values()) {
                EntityData.Component.Builder componentBuilder = EntityData.Component.newBuilder();
                componentBuilder.setTypeName(component.getClass().toString().replaceFirst("class ", ""));
                for (Field field : component.getClass().getDeclaredFields()) {
                    EntityData.Field.Builder fieldBuilder = EntityData.Field.newBuilder();
                    fieldBuilder.setName(field.getName());
                    fieldBuilder.setType(field.getType().toString());
                    field.setAccessible(true);
                    String value = "";
                    switch (field.getType().toString()) {
                        case "double": {
                            value = String.valueOf((Double)field.get(component));
                            break;
                        }
                        case "float": {
                            value = String.valueOf(((Float)field.get(component)).floatValue());
                            break;
                        }
                        case "int": {
                            value = String.valueOf((Integer)field.get(component));
                            break;
                        }
                        case "long": {
                            value = String.valueOf((Long)field.get(component));
                            break;
                        }
                        case "boolean": {
                            value = String.valueOf((Boolean)field.get(component));
                            break;
                        }
                        case "class java.lang.String": {
                            value = (String)field.get(component);
                            break;
                        }
                        case "class org.terasology.gestalt.assets.ResourceUrn": {
                            value = ((ResourceUrn)field.get(component)).toString();
                            break;
                        }
                        default: {
                            logger.error("Trying to serialise unknown data-type: '{}'", (Object)field);
                        }
                    }
                    fieldBuilder.setValue(ByteString.copyFrom((byte[])value.getBytes()));
                    componentBuilder.addField(fieldBuilder);
                }
                entityBuilder.addComponent(componentBuilder);
            }
            storeBuilder.addEntity(entityBuilder);
        }
        FileOutputStream output = new FileOutputStream(this.file);
        storeBuilder.build().writeTo(output);
        output.close();
    }

    public void deserialise() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        if (this.classLoader == null) {
            logger.warn("Trying to deserialise with Null classloader. Aborting");
            return;
        }
        FileInputStream input = new FileInputStream(this.file);
        EntityData.EntityStore store = EntityData.EntityStore.parseFrom(input);
        input.close();
        for (EntityData.Entity entity : store.getEntityList()) {
            ArrayList componentsToAdd = Lists.newArrayList();
            for (EntityData.Component component : entity.getComponentList()) {
                Class<?> componentClass = Class.forName(component.getTypeName(), true, this.classLoader);
                Component componentObject = (Component)componentClass.newInstance();
                block20: for (EntityData.Field field : component.getFieldList()) {
                    Field componentObjectField = componentClass.getDeclaredField(field.getName());
                    componentObjectField.setAccessible(true);
                    String value = new String(field.getValue().toByteArray());
                    switch (field.getType()) {
                        case "double": {
                            componentObjectField.set(componentObject, Double.valueOf(value));
                            continue block20;
                        }
                        case "float": {
                            componentObjectField.set(componentObject, Float.valueOf(value));
                            continue block20;
                        }
                        case "int": {
                            componentObjectField.set(componentObject, Integer.valueOf(value));
                            continue block20;
                        }
                        case "long": {
                            componentObjectField.set(componentObject, Long.valueOf(value));
                            continue block20;
                        }
                        case "boolean": {
                            componentObjectField.set(componentObject, Boolean.valueOf(value));
                            continue block20;
                        }
                        case "class java.lang.String": {
                            componentObjectField.set(componentObject, value);
                            continue block20;
                        }
                        case "class org.terasology.gestalt.assets.ResourceUrn": {
                            componentObjectField.set(componentObject, new ResourceUrn(value));
                            continue block20;
                        }
                    }
                    logger.error("Trying to deserialise unknown data-type: '{}'", (Object)componentObjectField);
                }
                componentsToAdd.add(componentObject);
            }
            this.entityManager.createEntity((Collection)componentsToAdd);
        }
    }
}

