/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.files;

import com.badlogic.gdx.math.Vector2;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.AbilityCommonConfigs;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.hulls.GunSlot;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.modules.ModuleManager;
import org.json.JSONArray;
import org.json.JSONObject;

public final class HullConfigManager {
    private final ItemManager itemManager;
    private final AbilityCommonConfigs abilityCommonConfigs;
    private final Map<String, HullConfig> nameToConfigMap;
    private final Map<HullConfig, String> configToNameMap;
    private static final Map<String, Class<AbilityConfig>> abilityClasses = new HashMap<String, Class<AbilityConfig>>();
    private static final String LOAD_JSON_METHOD_NAME = "load";

    public HullConfigManager(ItemManager itemManager, AbilityCommonConfigs abilityCommonConfigs) {
        this.itemManager = itemManager;
        this.abilityCommonConfigs = abilityCommonConfigs;
        this.nameToConfigMap = new HashMap<String, HullConfig>();
        this.configToNameMap = new HashMap<HullConfig, String>();
    }

    private static Vector2 readVector2(JSONObject JSONObject2, String name, Vector2 defaultValue) {
        String string = JSONObject2.optString(name, null);
        return string == null ? defaultValue : SolMath.readV2(string);
    }

    private static Engine.Config readEngineConfig(String engineName, ItemManager itemManager) {
        if (engineName == null) {
            return null;
        }
        return itemManager.getEngineConfig(engineName);
    }

    private static void validateEngineConfig(HullConfig.Data hull) {
        if (hull.engineConfig != null && (hull.type == HullConfig.Type.STATION || hull.engineConfig.isBig != (hull.type == HullConfig.Type.BIG))) {
            throw new AssertionError((Object)("Incompatible engine in hull " + hull.displayName));
        }
    }

    public HullConfig getConfig(String shipName) {
        HullConfig hullConfig = this.nameToConfigMap.get(shipName);
        if (hullConfig == null) {
            hullConfig = this.read(shipName);
            this.nameToConfigMap.put(shipName, hullConfig);
            this.configToNameMap.put(hullConfig, shipName);
        }
        return hullConfig;
    }

    public String getName(HullConfig hull) {
        String name = this.configToNameMap.get(hull);
        return name == null ? "" : name;
    }

    private HullConfig read(String shipName) {
        HullConfig.Data configData = new HullConfig.Data();
        configData.internalName = shipName;
        JSONObject rootNode = Validator.getValidatedJSON(shipName, "engine:schemaHullConfig");
        this.readProperties(rootNode, configData);
        configData.tex = Assets.getAtlasRegion(shipName);
        configData.icon = Assets.getAtlasRegion(shipName + "Icon");
        HullConfigManager.validateEngineConfig(configData);
        return new HullConfig(configData);
    }

    private void parseGunSlotList(JSONArray containerNode, HullConfig.Data configData) {
        Vector2 builderOrigin = new Vector2(configData.shipBuilderOrigin);
        for (int i = 0; i < containerNode.length(); ++i) {
            JSONObject gunSlotNode = containerNode.getJSONObject(i);
            Vector2 position = HullConfigManager.readVector2(gunSlotNode, "position", null);
            position.sub(builderOrigin).scl(configData.size);
            boolean isUnderneathHull = gunSlotNode.optBoolean("isUnderneathHull", false);
            boolean allowsRotation = gunSlotNode.optBoolean("allowsRotation", true);
            configData.gunSlots.add(new GunSlot(position, isUnderneathHull, allowsRotation));
        }
    }

    private void parseParticleEmitters(JSONArray containerNode, HullConfig.Data configData) {
        Vector2 builderOrigin = new Vector2(configData.shipBuilderOrigin);
        for (int i = 0; i < containerNode.length(); ++i) {
            JSONObject particleEmitterNode = containerNode.getJSONObject(i);
            Vector2 position = HullConfigManager.readVector2(particleEmitterNode, "position", null);
            position.sub(builderOrigin).scl(configData.size);
            String trigger = particleEmitterNode.optString("trigger", null);
            float angleOffset = (float)particleEmitterNode.optDouble("angleOffset", 0.0);
            boolean hasLight = particleEmitterNode.optBoolean("hasLight", false);
            JSONObject particleNode = particleEmitterNode.getJSONObject("particle");
            ArrayList<String> workSounds = new ArrayList();
            if (particleEmitterNode.has("workSounds")) {
                workSounds = Assets.convertToStringList(particleEmitterNode.getJSONArray("workSounds"));
            }
            configData.particleEmitters.add(new DSParticleEmitter(position, trigger, angleOffset, hasLight, particleNode, workSounds));
        }
    }

    private void readProperties(JSONObject rootNode, HullConfig.Data configData) {
        configData.size = (float)rootNode.optDouble("size");
        configData.approxRadius = 0.4f * configData.size;
        configData.maxLife = rootNode.getInt("maxLife");
        configData.lightSrcPoss = SolMath.readV2List(rootNode, "lightSrcPoss");
        configData.forceBeaconPoss = SolMath.readV2List(rootNode, "forceBeaconPoss");
        configData.doorPoss = SolMath.readV2List(rootNode, "doorPoss");
        configData.type = HullConfig.Type.forName(rootNode.optString("type"));
        configData.durability = configData.type == HullConfig.Type.BIG ? 3.0f : 0.25f;
        configData.engineConfig = HullConfigManager.readEngineConfig(rootNode.optString("engine", null), this.itemManager);
        configData.ability = this.loadAbility(rootNode, this.itemManager, this.abilityCommonConfigs);
        configData.displayName = rootNode.optString("displayName", "---");
        configData.price = (float)rootNode.optDouble("price", 0.0);
        configData.hirePrice = (float)rootNode.optDouble("hirePrice", 0.0);
        Vector2 tmpV = new Vector2((float)rootNode.getJSONObject("rigidBody").getJSONObject("origin").getDouble("x"), 1.0f - (float)rootNode.getJSONObject("rigidBody").getJSONObject("origin").getDouble("y"));
        configData.shipBuilderOrigin.set(tmpV);
        this.process(configData);
        this.parseGunSlotList(rootNode.getJSONArray("gunSlots"), configData);
        if (rootNode.has("particleEmitters")) {
            this.parseParticleEmitters(rootNode.getJSONArray("particleEmitters"), configData);
        }
    }

    private AbilityConfig loadAbility(JSONObject hullNode, ItemManager manager, AbilityCommonConfigs commonConfigs) {
        JSONObject abNode;
        JSONObject jSONObject = abNode = hullNode.has("ability") ? hullNode.getJSONObject("ability") : null;
        if (abNode == null) {
            return null;
        }
        String type = abNode.optString("type").toLowerCase(Locale.ENGLISH);
        if (abilityClasses.containsKey(type)) {
            try {
                Method loadMethod = abilityClasses.get(type).getDeclaredMethod(LOAD_JSON_METHOD_NAME, JSONObject.class, ItemManager.class, AbilityCommonConfig.class);
                return (AbilityConfig)loadMethod.invoke(null, abNode, manager, commonConfigs.abilityConfigs.get(type));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void process(HullConfig.Data configData) {
        Vector2 builderOrigin = new Vector2(configData.shipBuilderOrigin);
        configData.origin.set(builderOrigin).scl(configData.size);
        for (Vector2 position : configData.lightSrcPoss) {
            position.sub(builderOrigin).scl(configData.size);
        }
        for (Vector2 position : configData.forceBeaconPoss) {
            position.sub(builderOrigin).scl(configData.size);
        }
        for (Vector2 position : configData.doorPoss) {
            position.sub(builderOrigin).scl(configData.size);
        }
    }

    static {
        for (Class abilityClass : ModuleManager.getEnvironmentStatic().getSubtypesOf(AbilityConfig.class)) {
            try {
                abilityClasses.put(abilityClass.getSimpleName().replace("Config", "").toLowerCase(Locale.ENGLISH), abilityClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

