/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.particle.EffectTypes;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class AbilityCommonConfigs {
    public final Map<String, AbilityCommonConfig> abilityConfigs = new HashMap<String, AbilityCommonConfig>();

    public AbilityCommonConfigs(EffectTypes effectTypes, GameColors cols, OggSoundManager soundManager) {
        for (ResourceUrn resource : Assets.getAssetHelper().listAssets(Json.class, "abilitiesConfig")) {
            JSONObject rootNode = Validator.getValidatedJSON(resource.toString(), "engine:schemaAbilitiesConfig");
            for (String abilityName : rootNode.keySet()) {
                String normalisedName = abilityName.toLowerCase(Locale.ENGLISH);
                if (this.abilityConfigs.containsKey(normalisedName)) continue;
                this.abilityConfigs.put(normalisedName, AbilityCommonConfig.load(rootNode.getJSONObject(abilityName), effectTypes, cols, soundManager));
            }
        }
    }
}

