/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.FarObjData;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.Hero;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.DrawableObject;
import org.destinationsol.game.drawables.FarDrawable;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.planet.PlanetBind;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;

public class BeaconHandler
implements UpdateAwareSystem {
    private static final float TEX_SZ = 0.5f;
    private static final float ROT_SPD = 30.0f;
    private static final String ATTACK_SPRITE_NAME = "engine:uiBeaconAttack";
    private static final String FOLLOW_SPRITE_NAME = "engine:uiBeaconFollow";
    private static final String MOVE_SPRITE_NAME = "engine:uiBeaconMove";
    private final RectSprite attackSprite = SpriteManager.createSprite("engine:uiBeaconAttack", 0.5f, 0.0f, 0.0f, new Vector2(), DrawableLevel.PART_FG_0, 0.0f, 30.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), true);
    private final RectSprite followSprite = SpriteManager.createSprite("engine:uiBeaconFollow", 0.5f, 0.0f, 0.0f, new Vector2(), DrawableLevel.PART_FG_0, 0.0f, 30.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), true);
    private final RectSprite moveSprite = SpriteManager.createSprite("engine:uiBeaconMove", 0.5f, 0.0f, 0.0f, new Vector2(), DrawableLevel.PART_FG_0, 0.0f, 30.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), true);
    private final Vector2 targetRelativePosition = new Vector2();
    private DrawableObject drawable;
    private FarDrawable farDrawable;
    private Pilot targetPilot;
    private SolShip target;
    private FarShip farTarget;
    private Action currentAction;
    private PlanetBind planetBind;
    private float clickTime;
    private Vector2 velocity = new Vector2();
    private boolean isInitialized;

    public void init(SolGame game, Vector2 position) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        drawables.add(this.attackSprite);
        drawables.add(this.followSprite);
        drawables.add(this.moveSprite);
        this.drawable = new DrawableObject(drawables, new Vector2(position), new Vector2(), null, false, false);
        game.getObjectManager().addObjDelayed(this.drawable);
        this.isInitialized = true;
    }

    @Override
    public void update(SolGame game, float timeStep) {
        if (!this.isInitialized) {
            return;
        }
        this.updateD(game);
        this.velocity.set(0.0f, 0.0f);
        if (this.maybeUpdateTargetPos(game)) {
            return;
        }
        this.maybeUpdatePlanetPos(game);
    }

    private void maybeUpdatePlanetPos(SolGame game) {
        Vector2 beaconPos = this.getPos0();
        if (this.planetBind == null) {
            this.planetBind = PlanetBind.tryBind(game, beaconPos, 0.0f);
            return;
        }
        Vector2 vec = SolMath.getVec();
        this.planetBind.setDiff(vec, beaconPos, false);
        beaconPos.add(vec);
        SolMath.free(vec);
        this.planetBind.getPlanet().calculateVelocityAtPosition(this.velocity, beaconPos);
    }

    private boolean maybeUpdateTargetPos(SolGame game) {
        this.updateTarget(game);
        if (this.targetPilot == null) {
            return false;
        }
        Vector2 beaconPos = this.getPos0();
        if (this.target != null) {
            SolMath.toWorld(beaconPos, this.targetRelativePosition, this.target.getAngle(), this.target.getPosition());
            this.velocity.set(this.target.getVelocity());
        } else {
            beaconPos.set(this.farTarget.getPosition());
        }
        return true;
    }

    private void updateTarget(SolGame game) {
        if (this.targetPilot == null) {
            return;
        }
        ObjectManager om = game.getObjectManager();
        List<SolObject> objs = om.getObjects();
        List<FarShip> farShips = om.getFarShips();
        if (this.target != null) {
            if (objs.contains(this.target)) {
                return;
            }
            this.target = null;
            for (FarShip ship : farShips) {
                if (ship.getPilot() != this.targetPilot) continue;
                this.farTarget = ship;
                return;
            }
            this.applyAction(Action.MOVE);
            return;
        }
        if (this.farTarget == null) {
            throw new AssertionError((Object)"Far target does not exist!");
        }
        if (om.getFarShips().contains(this.farTarget)) {
            return;
        }
        this.farTarget = null;
        for (SolObject o : objs) {
            SolShip ship;
            if (!(o instanceof SolShip) || (ship = (SolShip)o).getPilot() != this.targetPilot) continue;
            this.target = ship;
            return;
        }
        this.applyAction(Action.MOVE);
    }

    private void updateD(SolGame game) {
        ObjectManager om = game.getObjectManager();
        List<SolObject> objs = om.getObjects();
        List<FarObjData> farObjs = om.getFarObjs();
        if (this.drawable != null) {
            if (objs.contains(this.drawable)) {
                return;
            }
            this.drawable = null;
            for (FarObjData fod : farObjs) {
                Drawable drawable;
                List<Drawable> drawables;
                FarObject fo = fod.fo;
                if (!(fo instanceof FarDrawable) || (drawables = ((FarDrawable)fo).getDrawables()).size() != 3 || (drawable = drawables.get(0)) != this.attackSprite) continue;
                this.farDrawable = (FarDrawable)fo;
                return;
            }
            throw new AssertionError();
        }
        if (this.farDrawable == null) {
            throw new AssertionError((Object)"Far drawable does not exist!");
        }
        if (om.containsFarObj(this.farDrawable)) {
            return;
        }
        this.farDrawable = null;
        for (SolObject o : objs) {
            Drawable drawable;
            List<Drawable> drawables;
            if (!(o instanceof DrawableObject) || (drawables = o.getDrawables()).size() != 3 || (drawable = drawables.get(0)) != this.attackSprite) continue;
            this.drawable = (DrawableObject)o;
            return;
        }
        throw new AssertionError();
    }

    public Action processMouse(SolGame game, Vector2 position, boolean clicked, boolean onMap) {
        Action action;
        Pilot targetPilot = this.findPilotInPos(game, position, onMap, clicked);
        if (targetPilot != null) {
            boolean enemies = game.getFactionMan().areEnemies(targetPilot.getFaction(), game.getHero().getPilot().getFaction());
            if (enemies) {
                action = Action.ATTACK;
                if (clicked) {
                    this.targetRelativePosition.set(0.0f, 0.0f);
                }
            } else {
                action = Action.FOLLOW;
                if (clicked) {
                    if (this.target == null) {
                        this.targetRelativePosition.set(0.0f, 0.0f);
                    } else {
                        SolMath.toRel(position, this.targetRelativePosition, this.target.getAngle(), this.target.getPosition());
                    }
                }
            }
        } else {
            action = Action.MOVE;
        }
        if (clicked) {
            this.applyAction(action);
            this.getPos0().set(position);
            this.clickTime = game.getTime();
        }
        return action;
    }

    private void applyAction(Action action) {
        this.currentAction = action;
        this.attackSprite.tint.a = this.currentAction == Action.ATTACK ? 1.0f : 0.0f;
        this.moveSprite.tint.a = this.currentAction == Action.MOVE ? 1.0f : 0.0f;
        this.followSprite.tint.a = this.currentAction == Action.FOLLOW ? 1.0f : 0.0f;
        this.planetBind = null;
        if (this.currentAction == Action.MOVE) {
            this.targetPilot = null;
            this.target = null;
            this.farTarget = null;
        }
    }

    private Pilot findPilotInPos(SolGame game, Vector2 position, boolean onMap, boolean clicked) {
        ObjectManager objectManager = game.getObjectManager();
        Hero hero = game.getHero();
        float iconRad = onMap ? game.getMapDrawer().getIconRadius(game.getCam()) : 0.0f;
        for (SolObject o : objectManager.getObjects()) {
            if (o == hero.getShipUnchecked() || !(o instanceof SolShip)) continue;
            SolShip s = (SolShip)o;
            Pilot pilot = s.getPilot();
            if (onMap && pilot.getMapHint() == null) continue;
            float dst = o.getPosition().dst(position);
            float f = iconRad == 0.0f ? s.getHull().config.getSize() : iconRad;
            float rad = f;
            if (!(dst < rad)) continue;
            if (clicked) {
                this.targetPilot = pilot;
                this.target = s;
            }
            return pilot;
        }
        for (FarShip s : objectManager.getFarShips()) {
            Pilot pilot = s.getPilot();
            if (onMap && pilot.getMapHint() == null) continue;
            float dst = s.getPosition().dst(position);
            float f = iconRad == 0.0f ? s.getHullConfig().getApproxRadius() : iconRad;
            float rad = f;
            if (!(dst < rad)) continue;
            if (clicked) {
                this.targetPilot = pilot;
                this.farTarget = s;
            }
            return pilot;
        }
        return null;
    }

    public Vector2 getPos() {
        return this.getPos0();
    }

    private Vector2 getPos0() {
        return this.drawable == null ? this.farDrawable.getPosition() : this.drawable.getPosition();
    }

    public Action getCurrAction() {
        return this.currentAction;
    }

    public float getClickTime() {
        return this.clickTime;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public static enum Action {
        MOVE,
        ATTACK,
        FOLLOW;

    }
}

