/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.SolSystem;

public interface CamRotStrategy {
    public float getRotation(Vector2 var1, SolGame var2);

    public static class ToPlanet
    implements CamRotStrategy {
        @Override
        public float getRotation(Vector2 position, SolGame game) {
            Planet np = game.getPlanetManager().getNearestPlanet();
            if (np == null) {
                return 0.0f;
            }
            float fh = np.getFullHeight();
            Vector2 npPos = np.getPosition();
            if (npPos.dst(position) < fh) {
                return SolMath.angle(position, npPos) - 90.0f;
            }
            SolSystem sys = game.getPlanetManager().getNearestSystem(position);
            Vector2 sysPos = sys.getPosition();
            if (sysPos.dst(position) < 78.0f) {
                return SolMath.angle(position, sysPos) - 90.0f;
            }
            return 0.0f;
        }
    }

    public static class Static
    implements CamRotStrategy {
        @Override
        public float getRotation(Vector2 position, SolGame game) {
            return 0.0f;
        }
    }
}

