/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONArray;
import org.json.JSONObject;

public class CollisionMeshLoader {
    private final Model model = new Model();
    private final List<Vector2> vectorPool = new ArrayList<Vector2>();
    private final PolygonShape polygonShape = new PolygonShape();
    private final CircleShape circleShape = new CircleShape();
    private final Vector2 vec = new Vector2();

    public CollisionMeshLoader() {
    }

    public CollisionMeshLoader(String fileName) {
        JSONObject rootNode = Validator.getValidatedJSON(fileName, "engine:schemaCollisionMesh");
        this.readModel(rootNode);
    }

    public boolean attachFixture(Body body, String name, FixtureDef fd, float scale) {
        RigidBodyModel rbModel = this.model.rigidBodies.get(name);
        if (rbModel == null) {
            return false;
        }
        Vector2 origin = this.vec.set(rbModel.origin).scl(scale);
        for (PolygonModel polygon : rbModel.polygons) {
            Vector2[] points = polygon.tmpArray;
            int pointCount = points.length;
            for (int i = 0; i < pointCount; ++i) {
                Vector2 origPoint = polygon.vertices.get(pointCount - i - 1);
                points[i] = this.newVec(origPoint).scl(scale);
                points[i].sub(origin);
            }
            this.polygonShape.set(points);
            fd.shape = this.polygonShape;
            body.createFixture(fd);
            for (Vector2 point : points) {
                this.free(point);
            }
        }
        for (CircleModel circle : rbModel.circles) {
            Vector2 center = this.newVec(circle.center).scl(scale).sub(origin);
            float radius = circle.radius * scale;
            this.circleShape.setPosition(center);
            this.circleShape.setRadius(radius);
            fd.shape = this.circleShape;
            body.createFixture(fd);
            this.free(center);
        }
        return true;
    }

    public Vector2 getOrigin(String name, float scale) {
        RigidBodyModel rbModel = this.model.rigidBodies.get(name);
        if (rbModel == null) {
            this.vec.set(0.5f, 0.5f);
        } else {
            this.vec.set(rbModel.origin);
        }
        this.vec.scl(scale);
        return this.vec;
    }

    public Model getInternalModel() {
        return this.model;
    }

    private void readModel(JSONObject rootNode) {
        JSONArray rbNode = rootNode.getJSONArray("rigidBodies");
        for (int i = 0; i < rbNode.length(); ++i) {
            this.readRigidBody(rbNode.getJSONObject(i));
        }
    }

    public void readRigidBody(JSONObject rbNode) {
        this.readRigidBody(rbNode, rbNode.getString("name"));
    }

    public void readRigidBody(JSONObject rbNode, HullConfig hullConfig) {
        String shipName = hullConfig.getInternalName();
        this.readRigidBody(rbNode, shipName);
    }

    public void readRigidBody(JSONObject rbNode, String shipName) {
        RigidBodyModel rbModel = new RigidBodyModel();
        rbModel.name = shipName;
        JSONObject originNode = rbNode.getJSONObject("origin");
        rbModel.origin.x = (float)originNode.getDouble("x");
        rbModel.origin.y = 1.0f - (float)originNode.getDouble("y");
        JSONArray polygonNodeArray = rbNode.getJSONArray("polygons");
        for (int i = 0; i < polygonNodeArray.length(); ++i) {
            JSONArray polygonNode = polygonNodeArray.getJSONArray(i);
            PolygonModel polygonModel = new PolygonModel();
            rbModel.polygons.add(polygonModel);
            for (int j = 0; j < polygonNode.length(); ++j) {
                JSONObject vertexNode = polygonNode.getJSONObject(j);
                float x = (float)vertexNode.getDouble("x");
                float y = 1.0f - (float)vertexNode.getDouble("y");
                polygonModel.vertices.add(new Vector2(x, y));
            }
            PolygonModel.access$002(polygonModel, new Vector2[polygonModel.vertices.size()]);
        }
        JSONArray shapeNodeArray = rbNode.getJSONArray("shapes");
        for (int i = 0; i < shapeNodeArray.length(); ++i) {
            JSONObject shapeNode = shapeNodeArray.getJSONObject(i);
            String type = shapeNode.getString("type");
            if (!type.equals("POLYGON")) continue;
            PolygonModel shapeModel = new PolygonModel();
            rbModel.shapes.add(shapeModel);
            JSONArray vertices = shapeNode.getJSONArray("vertices");
            for (int j = 0; j < vertices.length(); ++j) {
                JSONObject vertexNode = vertices.getJSONObject(j);
                float x = (float)vertexNode.getDouble("x");
                float y = 1.0f - (float)vertexNode.getDouble("y");
                shapeModel.vertices.add(new Vector2(x, y));
            }
            PolygonModel.access$002(shapeModel, new Vector2[shapeModel.vertices.size()]);
        }
        JSONArray circles = rbNode.getJSONArray("circles");
        for (int i = 0; i < circles.length(); ++i) {
            CircleModel circleModel = new CircleModel();
            rbModel.circles.add(circleModel);
            JSONObject circleNode = circles.getJSONObject(i);
            circleModel.center.x = (float)circleNode.getDouble("cx");
            circleModel.center.y = 1.0f - (float)circleNode.getDouble("cy");
            circleModel.radius = (float)circleNode.getDouble("r");
        }
        this.model.rigidBodies.put(rbModel.name, rbModel);
    }

    private Vector2 newVec(Vector2 v) {
        Vector2 res;
        Vector2 vector2 = res = this.vectorPool.isEmpty() ? new Vector2() : this.vectorPool.remove(0);
        if (v != null) {
            res.set(v);
        }
        return res;
    }

    private void free(Vector2 v) {
        this.vectorPool.add(v);
    }

    public Body getBodyAndSprite(SolGame game, HullConfig hullConfig, float scale, BodyDef.BodyType type, Vector2 position, float angle, List<Drawable> drawables, float density, DrawableLevel level, TextureAtlas.AtlasRegion tex) {
        String name = hullConfig.getInternalName();
        BodyDef bd = new BodyDef();
        bd.type = type;
        bd.angle = angle * ((float)Math.PI / 180);
        bd.angularDamping = 0.0f;
        bd.position.set(position);
        bd.linearDamping = 0.0f;
        Body body = game.getObjectManager().getWorld().createBody(bd);
        FixtureDef fd = new FixtureDef();
        fd.density = density;
        fd.friction = 0.5f;
        boolean found = this.attachFixture(body, name, fd, scale);
        if (!found) {
            DebugOptions.MISSING_PHYSICS_ACTION.handle("Could not find physics data for " + name);
            fd.shape = new CircleShape();
            fd.shape.setRadius(scale / 2.0f);
            body.createFixture(fd);
            fd.shape.dispose();
        }
        Vector2 orig = hullConfig.getShipBuilderOrigin();
        if (tex == null) {
            tex = hullConfig.getTexture();
        }
        RectSprite s = SpriteManager.createSprite(name, scale, orig.x - 0.5f, orig.y - 0.5f, new Vector2(), level, 0.0f, 0.0f, SolColor.WHITE, false);
        drawables.add(s);
        return body;
    }

    public Body getBodyAndSprite(World world, TextureAtlas.AtlasRegion tex, float scale, BodyDef.BodyType type, Vector2 position, float angle, List<Drawable> drawables, float density, DrawableLevel level) {
        BodyDef bd = new BodyDef();
        bd.type = type;
        bd.angle = angle * ((float)Math.PI / 180);
        bd.angularDamping = 0.0f;
        bd.position.set(position);
        bd.linearDamping = 0.0f;
        Body body = world.createBody(bd);
        FixtureDef fd = new FixtureDef();
        fd.density = density;
        fd.friction = 0.5f;
        boolean found = this.attachFixture(body, tex.name, fd, scale);
        if (!found) {
            DebugOptions.MISSING_PHYSICS_ACTION.handle("Could not find physics data for " + tex.name);
            fd.shape = new CircleShape();
            fd.shape.setRadius(scale / 2.0f);
            body.createFixture(fd);
            fd.shape.dispose();
        }
        Vector2 orig = this.getOrigin(tex.name, 1.0f);
        RectSprite s = SpriteManager.createSprite(tex.name, scale, orig.x - 0.5f, orig.y - 0.5f, new Vector2(), level, 0.0f, 0.0f, SolColor.WHITE, false);
        drawables.add(s);
        return body;
    }

    public static class Model {
        public final Map<String, RigidBodyModel> rigidBodies = new HashMap<String, RigidBodyModel>();
    }

    public static class RigidBodyModel {
        public final Vector2 origin = new Vector2();
        public final List<PolygonModel> polygons = new ArrayList<PolygonModel>();
        public final List<PolygonModel> shapes = new ArrayList<PolygonModel>();
        public final List<CircleModel> circles = new ArrayList<CircleModel>();
        public String name;
    }

    public static class PolygonModel {
        public final List<Vector2> vertices = new ArrayList<Vector2>();
        private Vector2[] tmpArray;

        static /* synthetic */ Vector2[] access$002(PolygonModel x0, Vector2[] x1) {
            x0.tmpArray = x1;
            return x1;
        }
    }

    public static class CircleModel {
        public final Vector2 center = new Vector2();
        public float radius;
    }
}

