/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import org.destinationsol.common.SolColorUtil;
import org.destinationsol.game.HsbSpan;

public abstract class ColorSpan {
    public static RgbSpan rgb(Color start, Color end) {
        return new RgbSpan(start, end);
    }

    public static RgbSpan rgb(float[] start, float[] end) {
        Color startC = new Color();
        SolColorUtil.fromHSB(start[0], start[1], start[2], start[3], startC);
        Color endC = new Color();
        SolColorUtil.fromHSB(end[0], end[1], end[2], end[3], endC);
        return ColorSpan.rgb(startC, endC);
    }

    public static HsbSpan hsb(Color start, Color end) {
        return ColorSpan.hsb(SolColorUtil.toHSB(start), SolColorUtil.toHSB(end));
    }

    public static HsbSpan hsb(float[] start, float[] end) {
        return new HsbSpan(start, end);
    }

    public abstract void set(float var1, Color var2);

    public static class RgbSpan
    extends ColorSpan {
        private final Color myStart;
        private final Color myEnd;

        public RgbSpan(Color start, Color end) {
            this.myStart = new Color(start);
            this.myEnd = new Color(end);
        }

        @Override
        public void set(float perc, Color col) {
            perc = MathUtils.clamp((float)perc, (float)0.0f, (float)1.0f);
            col.r = this.midVal(this.myStart.r, this.myEnd.r, perc);
            col.g = this.midVal(this.myStart.g, this.myEnd.g, perc);
            col.b = this.midVal(this.myStart.b, this.myEnd.b, perc);
            col.a = this.midVal(this.myStart.a, this.myEnd.a, perc);
        }

        private float midVal(float s, float e, float perc) {
            return s + perc * (e - s);
        }
    }
}

