/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.IniReader;
import org.destinationsol.SolFileReader;
import org.destinationsol.game.MissingResourceAction;

public class DebugOptions {
    public static final Vector2 DEBUG_POINT = new Vector2();
    public static final Vector2 DEBUG_POINT2 = new Vector2();
    public static final Vector2 DEBUG_POINT3 = new Vector2();
    public static final boolean ASSERTIONS = false;
    public static final boolean PRINT_BALANCE = false;
    public static String DEV_ROOT_PATH;
    public static boolean EMULATE_MOBILE;
    public static String SPAWN_PLACE;
    public static String FORCE_PLANET_TYPE;
    public static String FORCE_SYSTEM_TYPE;
    public static boolean NO_OBJS;
    public static boolean NO_DRAS;
    public static float ZOOM_OVERRIDE;
    public static float GRID_SZ;
    public static float GAME_SPEED_MULTIPLIER;
    public static boolean DETAILED_MAP;
    public static boolean NO_SOUND;
    public static boolean SOUND_IN_SPACE;
    public static boolean SHOW_WARNINGS;
    public static boolean SHOW_FPS;
    public static boolean DRAW_OBJ_BORDERS;
    public static boolean DRAW_DRA_BORDERS;
    public static boolean DRAW_PHYSIC_BORDERS;
    public static boolean DRAW_PLANET_BORDERS;
    public static boolean MISC_INFO;
    public static boolean OBJ_INFO;
    public static boolean SOUND_INFO;
    public static boolean TEX_INFO;
    public static MissingResourceAction MISSING_SOUND_ACTION;
    public static MissingResourceAction MISSING_TEXTURE_ACTION;
    public static MissingResourceAction MISSING_PHYSICS_ACTION;

    public static void read(SolFileReader reader) {
        IniReader r = new IniReader("debugOptions.ini", reader);
        EMULATE_MOBILE = r.getBoolean("emulateMobile", EMULATE_MOBILE);
        SPAWN_PLACE = r.getString("spawnPlace", SPAWN_PLACE);
        FORCE_PLANET_TYPE = r.getString("forcePlanetType", FORCE_PLANET_TYPE);
        FORCE_SYSTEM_TYPE = r.getString("forceSystemType", FORCE_SYSTEM_TYPE);
        NO_OBJS = r.getBoolean("noObjs", NO_OBJS);
        NO_DRAS = r.getBoolean("noDras", NO_DRAS);
        ZOOM_OVERRIDE = r.getFloat("zoomOverride", ZOOM_OVERRIDE);
        GRID_SZ = r.getFloat("gridSz", GRID_SZ);
        GAME_SPEED_MULTIPLIER = r.getFloat("gameSpeedMultiplier", GAME_SPEED_MULTIPLIER);
        DETAILED_MAP = r.getBoolean("detailedMap", DETAILED_MAP);
        NO_SOUND = r.getBoolean("noSound", NO_SOUND);
        SOUND_IN_SPACE = r.getBoolean("soundInSpace", SOUND_IN_SPACE);
        SHOW_WARNINGS = r.getBoolean("showWarnings", SHOW_WARNINGS);
        SHOW_FPS = r.getBoolean("showFps", SHOW_FPS);
        DRAW_OBJ_BORDERS = r.getBoolean("drawObjBorders", DRAW_OBJ_BORDERS);
        DRAW_DRA_BORDERS = r.getBoolean("drawDraBorders", DRAW_DRA_BORDERS);
        DRAW_PHYSIC_BORDERS = r.getBoolean("drawPhysicBorders", DRAW_PHYSIC_BORDERS);
        DRAW_PLANET_BORDERS = r.getBoolean("drawPlanetBorders", DRAW_PLANET_BORDERS);
        MISC_INFO = r.getBoolean("miscInfo", MISC_INFO);
        OBJ_INFO = r.getBoolean("objInfo", OBJ_INFO);
        SOUND_INFO = r.getBoolean("soundInfo", SOUND_INFO);
        TEX_INFO = r.getBoolean("texInfo", TEX_INFO);
        MISSING_SOUND_ACTION = MissingResourceAction.forName(r.getString("missingSoundAction", MissingResourceAction.IGNORE.name));
        MISSING_TEXTURE_ACTION = MissingResourceAction.forName(r.getString("missingTextureAction", MissingResourceAction.IGNORE.name));
        MISSING_PHYSICS_ACTION = MissingResourceAction.forName(r.getString("missingPhysicsAction", MissingResourceAction.IGNORE.name));
    }

    static {
        EMULATE_MOBILE = false;
        SPAWN_PLACE = "";
        FORCE_PLANET_TYPE = "";
        FORCE_SYSTEM_TYPE = "";
        NO_OBJS = false;
        NO_DRAS = false;
        ZOOM_OVERRIDE = 0.0f;
        GRID_SZ = 0.0f;
        GAME_SPEED_MULTIPLIER = 1.0f;
        DETAILED_MAP = false;
        NO_SOUND = false;
        SOUND_IN_SPACE = false;
        SHOW_WARNINGS = false;
        SHOW_FPS = false;
        DRAW_OBJ_BORDERS = false;
        DRAW_DRA_BORDERS = false;
        DRAW_PHYSIC_BORDERS = false;
        DRAW_PLANET_BORDERS = false;
        MISC_INFO = false;
        OBJ_INFO = false;
        SOUND_INFO = false;
        TEX_INFO = false;
    }
}

