/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONArray;
import org.terasology.gestalt.assets.ResourceUrn;

public class FactionInfo {
    private static ArrayList<String> factionName = new ArrayList();
    private static ArrayList<String> factionColor = new ArrayList();
    private static ArrayList<Integer> factionDisposition = new ArrayList();

    public FactionInfo() {
        this.createFactionList();
    }

    private void createFactionList() {
        for (String modulePath : FactionInfo.getModuleSet()) {
            Json factionJson = Assets.getJson(modulePath);
            Validator.getValidatedJSON(modulePath, "engine:schemaFactions");
            JSONArray factionJsonArray = factionJson.getJsonValue().getJSONArray("factions");
            for (int n = 0; n < factionJsonArray.length(); ++n) {
                factionName.add(factionJsonArray.getJSONObject(n).getString("name").replace("\"", ""));
                factionColor.add(factionJsonArray.getJSONObject(n).getString("color").replace("\"", ""));
                factionDisposition.add(factionJsonArray.getJSONObject(n).getInt("disposition"));
            }
        }
    }

    private static Set<String> getModuleSet() {
        HashSet<String> moduleSet = new HashSet<String>();
        Set<ResourceUrn> moduleUrn = Assets.getAssetHelper().listAssets(Json.class, "factions");
        for (ResourceUrn module : moduleUrn) {
            moduleSet.add(module.toString());
        }
        return moduleSet;
    }

    public static void clearValues() {
        factionName.clear();
        factionColor.clear();
        factionDisposition.clear();
    }

    public static ArrayList getFactionNames() {
        return factionName;
    }

    public static ArrayList getFactionColors() {
        return factionColor;
    }

    public static int getFactionID(SolShip ship) {
        String shipName = ship.getHull().getHullConfig().getInternalName();
        for (String modulePath : FactionInfo.getModuleSet()) {
            Json factionJson = Assets.getJson(modulePath);
            Validator.getValidatedJSON(modulePath, "engine:schemaFactions");
            JSONArray factionJsonArray = factionJson.getJsonValue().getJSONArray("factions");
            shipName = shipName.replaceAll(".*:", "");
            for (int n = 0; n < factionJsonArray.length(); ++n) {
                for (int z = 0; z < factionJsonArray.getJSONObject(n).getJSONArray("ships").length(); ++z) {
                    if (!shipName.equals(factionJsonArray.getJSONObject(n).getJSONArray("ships").get(z))) continue;
                    return n;
                }
            }
        }
        return 0;
    }

    public static ArrayList<Integer> getDisposition() {
        return factionDisposition;
    }

    public static void setDisposition(int n, int num) {
        if (factionDisposition.get(n) <= 100) {
            factionDisposition.set(n, factionDisposition.get(n) + num);
        }
    }
}

