/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import java.util.List;
import org.destinationsol.game.Faction;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.projectile.Projectile;
import org.destinationsol.game.ship.SolShip;

public class FactionManager {
    private final MyRayBack myRayBack = new MyRayBack();

    public SolShip getNearestEnemy(SolGame game, SolShip ship) {
        Pilot pilot = ship.getPilot();
        float detectionDist = pilot.getDetectionDist();
        if (detectionDist <= 0.0f) {
            return null;
        }
        Faction f = pilot.getFaction();
        return this.getNearestEnemy(game, detectionDist += ship.getHull().config.getApproxRadius(), f, ship.getPosition());
    }

    public SolShip getNearestEnemy(SolGame game, Projectile projectile) {
        return this.getNearestEnemy(game, game.getCam().getViewDistance(), projectile.getFaction(), projectile.getPosition());
    }

    public SolShip getNearestEnemy(SolGame game, float detectionDist, Faction faction, Vector2 position) {
        SolShip nearestEnemyShip = null;
        float minimumDistance = detectionDist;
        List<SolObject> objects = game.getObjectManager().getObjects();
        for (SolObject solObject : objects) {
            float distance;
            SolShip potentialEnemyShip;
            if (!(solObject instanceof SolShip) || !this.areEnemies(faction, (potentialEnemyShip = (SolShip)solObject).getPilot().getFaction()) || minimumDistance < (distance = potentialEnemyShip.getPosition().dst(position) - potentialEnemyShip.getHull().config.getApproxRadius())) continue;
            minimumDistance = distance;
            nearestEnemyShip = potentialEnemyShip;
        }
        return nearestEnemyShip;
    }

    private boolean hasObstacles(SolGame game, SolShip shipFrom, SolShip shipTo) {
        this.myRayBack.shipFrom = shipFrom;
        this.myRayBack.shipTo = shipTo;
        this.myRayBack.hasObstacle = false;
        game.getObjectManager().getWorld().rayCast((RayCastCallback)this.myRayBack, shipFrom.getPosition(), shipTo.getPosition());
        return this.myRayBack.hasObstacle;
    }

    public boolean areEnemies(SolShip s1, SolShip s2) {
        Faction f1 = s1.getPilot().getFaction();
        Faction f2 = s2.getPilot().getFaction();
        return this.areEnemies(f1, f2);
    }

    public boolean areEnemies(Faction f1, Faction f2) {
        return f1 != null && f2 != null && f1 != f2;
    }

    private static class MyRayBack
    implements RayCastCallback {
        public SolShip shipFrom;
        public SolShip shipTo;
        public boolean hasObstacle;

        private MyRayBack() {
        }

        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            SolObject o = (SolObject)fixture.getBody().getUserData();
            if (o == this.shipFrom || o == this.shipTo) {
                return -1.0f;
            }
            this.hasObstacle = true;
            return 0.0f;
        }
    }
}

