/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.Faction;
import org.destinationsol.game.FarObjData;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.ExplorerDestProvider;
import org.destinationsol.game.input.Guardian;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.input.NoDestProvider;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.TradeConfig;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.planet.ConsumedAngles;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetManager;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SysConfig;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONObject;

public class GalaxyFiller {
    private static final float STATION_CONSUME_SECTOR = 45.0f;
    private final HullConfigManager hullConfigManager;
    private Vector2 mainStationPos = new Vector2();
    private HullConfig mainStationHc;

    public GalaxyFiller(HullConfigManager hullConfigManager) {
        this.hullConfigManager = hullConfigManager;
    }

    private Vector2 getPosForStation(SolSystem sys, boolean mainStation, ConsumedAngles angles) {
        float angleToSun;
        Planet planet;
        ArrayList<Planet> planets = sys.getPlanets();
        if (mainStation) {
            planet = planets.get(planets.size() - 2);
            angleToSun = planet.getAngleInSystem() + (float)(20 * SolMath.toInt(planet.getRotationSpeedInSystem() > 0.0f));
        } else {
            int planetIndex = SolRandom.seededRandomInt(planets.size() - 1);
            planet = planets.get(planetIndex);
            angleToSun = 0.0f;
            for (int i = 0; i < 10 && angles.isConsumed(angleToSun = SolRandom.seededRandomFloat(180.0f), 45.0f); ++i) {
            }
        }
        angles.add(angleToSun, 45.0f);
        float stationDist = planet.getDistance() + planet.getFullHeight() + 8.0f;
        Vector2 stationPos = new Vector2();
        SolMath.fromAl(stationPos, angleToSun, stationDist);
        stationPos.add(planet.getSystem().getPosition());
        return stationPos;
    }

    private FarShip build(SolGame game, ShipConfig config, Faction faction, boolean mainStation, SolSystem system, ConsumedAngles angles) {
        MoveDestProvider destProvider;
        Vector2 position;
        HullConfig hullConf = config.hull;
        float detectionDist = 5.4f;
        TradeConfig tradeConfig = null;
        if (hullConf.getType() == HullConfig.Type.STATION) {
            position = this.getPosForStation(system, mainStation, angles);
            destProvider = new NoDestProvider();
            tradeConfig = system.getConfig().tradeConfig;
        } else {
            position = this.getEmptySpace(game, system);
            boolean isBig = hullConf.getType() == HullConfig.Type.BIG;
            destProvider = new ExplorerDestProvider(position, !isBig, hullConf, system);
            if (isBig) {
                if (faction == Faction.LAANI) {
                    tradeConfig = system.getConfig().tradeConfig;
                }
            } else {
                detectionDist = (float)((double)detectionDist * 1.5);
            }
        }
        AiPilot pilot = new AiPilot(destProvider, true, faction, true, "something", detectionDist);
        float angle = mainStation ? 0.0f : SolRandom.seededRandomFloat(180.0f);
        boolean hasRepairer = faction == Faction.LAANI;
        int money = config.money;
        FarShip ship = game.getShipBuilder().buildNewFar(game, position, null, angle, 0.0f, pilot, config.items, hullConf, null, hasRepairer, money, tradeConfig, true);
        game.getObjectManager().addFarObjNow(ship);
        ShipConfig guardConf = config.guard;
        if (guardConf != null) {
            ConsumedAngles consumedAngles = new ConsumedAngles();
            int i = 0;
            while ((float)i < guardConf.density) {
                float guardianAngle = 0.0f;
                for (int j = 0; j < 5; ++j) {
                    guardianAngle = SolRandom.randomFloat(180.0f);
                    if (consumedAngles.isConsumed(guardianAngle, guardConf.hull.getApproxRadius())) continue;
                    consumedAngles.add(guardianAngle, guardConf.hull.getApproxRadius());
                    break;
                }
                this.createGuard(game, ship, guardConf, faction, guardianAngle);
                ++i;
            }
        }
        return ship;
    }

    public JSONObject getRootNode(Json json) {
        JSONObject node = json.getJsonValue();
        return node;
    }

    public void fill(SolGame game, HullConfigManager hullConfigManager, ItemManager itemManager, String moduleName) {
        if (DebugOptions.NO_OBJS) {
            return;
        }
        this.createStarPorts(game);
        ArrayList<SolSystem> systems = game.getPlanetManager().getSystems();
        JSONObject rootNode = Validator.getValidatedJSON(moduleName + ":startingStation", "engine:schemaStartingStation");
        ShipConfig mainStationCfg = ShipConfig.load(hullConfigManager, rootNode, itemManager);
        ConsumedAngles angles = new ConsumedAngles();
        FarShip mainStation = this.build(game, mainStationCfg, Faction.LAANI, true, systems.get(0), angles);
        this.mainStationPos.set(mainStation.getPosition());
        this.mainStationHc = mainStation.getHullConfig();
        for (SolSystem system : systems) {
            int i;
            int count;
            SysConfig sysConfig = system.getConfig();
            for (ShipConfig shipConfig : sysConfig.constAllies) {
                count = (int)shipConfig.density;
                for (i = 0; i < count; ++i) {
                    this.build(game, shipConfig, Faction.LAANI, false, system, angles);
                }
            }
            for (ShipConfig shipConfig : sysConfig.constEnemies) {
                count = (int)shipConfig.density;
                for (i = 0; i < count; ++i) {
                    this.build(game, shipConfig, Faction.EHAR, false, system, angles);
                }
            }
            angles = new ConsumedAngles();
        }
    }

    private void createStarPorts(SolGame game) {
        PlanetManager planetManager = game.getPlanetManager();
        ArrayList<Planet> biggest = new ArrayList<Planet>();
        for (SolSystem system : planetManager.getSystems()) {
            Planet planet2;
            int i;
            float minHeight = 0.0f;
            Planet biggestPlanet = null;
            int biggestPlanetIndex = -1;
            ArrayList<Planet> planets = system.getPlanets();
            for (i = 0; i < planets.size(); ++i) {
                planet2 = planets.get(i);
                float groundHeight = planet2.getGroundHeight();
                if (!(minHeight < groundHeight)) continue;
                minHeight = groundHeight;
                biggestPlanet = planet2;
                biggestPlanetIndex = i;
            }
            for (i = 0; i < planets.size(); ++i) {
                if (biggestPlanetIndex == i || biggestPlanetIndex == i - 1 || biggestPlanetIndex == i + 1) continue;
                planet2 = planets.get(i);
                this.link(game, planet2, biggestPlanet);
            }
            for (Planet planet2 : biggest) {
                this.link(game, planet2, biggestPlanet);
            }
            biggest.add(biggestPlanet);
        }
    }

    private void link(SolGame game, Planet firstPlanet, Planet secondPlanet) {
        if (firstPlanet == secondPlanet) {
            throw new AssertionError((Object)"Linking planet to itself");
        }
        Vector2 firstPlanetPosition = StarPort.getDesiredPosition(firstPlanet, secondPlanet, false);
        StarPort.FarStarPort starPort = new StarPort.FarStarPort(firstPlanet, secondPlanet, firstPlanetPosition, false);
        SolMath.free(firstPlanetPosition);
        game.getObjectManager().addFarObjNow(starPort);
        Vector2 secondPlanetPosition = StarPort.getDesiredPosition(secondPlanet, firstPlanet, false);
        starPort = new StarPort.FarStarPort(secondPlanet, firstPlanet, secondPlanetPosition, false);
        SolMath.free(secondPlanetPosition);
        game.getObjectManager().addFarObjNow(starPort);
    }

    private void createGuard(SolGame game, FarShip target, ShipConfig guardConfig, Faction faction, float guardRelAngle) {
        Guardian dp = new Guardian(game, guardConfig.hull, target.getPilot(), target.getPosition(), target.getHullConfig(), guardRelAngle);
        AiPilot pilot = new AiPilot(dp, true, faction, false, null, 5.4f);
        boolean hasRepairer = faction == Faction.LAANI;
        int money = guardConfig.money;
        FarShip enemy = game.getShipBuilder().buildNewFar(game, dp.getDestination(), null, guardRelAngle, 0.0f, pilot, guardConfig.items, guardConfig.hull, null, hasRepairer, money, null, true);
        game.getObjectManager().addFarObjNow(enemy);
    }

    private Vector2 getEmptySpace(SolGame game, SolSystem system) {
        Vector2 result = new Vector2();
        Vector2 systemPosition = system.getPosition();
        float systemRadius = system.getConfig().hard ? system.getRadius() : system.getInnerRadius();
        for (int i = 0; i < 100; ++i) {
            SolMath.fromAl(result, SolRandom.seededRandomFloat(180.0f), SolRandom.seededRandomFloat(systemRadius));
            result.add(systemPosition);
            if (!game.isPlaceEmpty(result, true)) continue;
            return result;
        }
        throw new AssertionError((Object)"could not generate ship position");
    }

    public Vector2 getPlayerSpawnPos(SolGame game) {
        Vector2 position = new Vector2(156.0f, 0.0f);
        if ("planet".equals(DebugOptions.SPAWN_PLACE)) {
            Planet planet = game.getPlanetManager().getPlanets().get(0);
            position.set(planet.getPosition());
            position.x += planet.getFullHeight();
        } else if (DebugOptions.SPAWN_PLACE.isEmpty() && this.mainStationPos != null) {
            SolMath.fromAl(position, 90.0f, this.mainStationHc.getSize() / 2.0f);
            position.add(this.mainStationPos);
        } else if ("maze".equals(DebugOptions.SPAWN_PLACE)) {
            Maze maze = game.getPlanetManager().getMazes().get(0);
            position.set(maze.getPos());
            position.x += maze.getRadius();
        } else if ("trader".equals(DebugOptions.SPAWN_PLACE)) {
            HullConfig config = this.hullConfigManager.getConfig("core:bus");
            for (FarObjData farObjData : game.getObjectManager().getFarObjs()) {
                FarObject farObject = farObjData.fo;
                if (!(farObject instanceof FarShip) || ((FarShip)farObject).getHullConfig() != config) continue;
                position.set(farObject.getPosition());
                position.add(config.getApproxRadius() * 2.0f, 0.0f);
                break;
            }
        }
        return position;
    }

    public Vector2 getMainStationPosition() {
        return this.mainStationPos;
    }
}

