/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import java.util.HashMap;
import java.util.Map;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolColorUtil;
import org.json.JSONObject;

public class GameColors {
    public final Color fire;
    public final Color smoke;
    public final Color hullLights;
    private final Map<String, Color> colors = new HashMap<String, Color>();

    public GameColors() {
        JSONObject rootNode = Validator.getValidatedJSON("core:colorsConfig", "engine:schemaColorsConfig");
        for (String key : rootNode.keySet()) {
            Color c = this.load(rootNode.getString(key));
            this.colors.put(key, c);
        }
        this.fire = this.get("fire");
        this.smoke = this.get("smoke");
        this.hullLights = this.get("hullLights");
    }

    public Color get(String name) {
        Color result = this.colors.get(name);
        if (result == null) {
            throw new AssertionError((Object)("Color " + name + " is not defined."));
        }
        return result;
    }

    public Color load(String s) {
        if (s.contains(" ")) {
            return SolColorUtil.load(s);
        }
        return this.get(s);
    }
}

