/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.CommonDrawer;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.SolGame;

public class GameDrawer {
    public final TextureAtlas.AtlasRegion debugWhiteTexture;
    private final CommonDrawer myDrawer;
    private boolean myCurrAdditive;

    public GameDrawer(CommonDrawer commonDrawer) {
        this.myDrawer = commonDrawer;
        this.debugWhiteTexture = Assets.getAtlasRegion("engine:uiWhiteTex");
    }

    public void begin() {
        this.myDrawer.begin();
    }

    public void updateMatrix(SolGame game) {
        this.myDrawer.setMatrix(game.getCam().getMtx());
    }

    public void end() {
        this.myDrawer.end();
    }

    public void drawString(String s, float x, float y, float size, boolean centered, Color col) {
        this.maybeChangeAdditive(false);
        this.myDrawer.drawString(s, x, y, size, centered, col);
    }

    public void draw(TextureRegion tr, float width, float height, float origX, float origY, float x, float y, float rot, Color tint) {
        this.maybeChangeAdditive(false);
        this.myDrawer.draw(tr, width, height, origX, origY, x, y, rot, tint);
    }

    public void drawAdditive(TextureRegion tr, float width, float height, float origX, float origY, float x, float y, float rot, Color tint) {
        this.maybeChangeAdditive(true);
        this.myDrawer.draw(tr, width, height, origX, origY, x, y, rot, tint);
    }

    public void drawLine(TextureRegion tex, float x, float y, float angle, float len, Color col, float width) {
        this.maybeChangeAdditive(false);
        this.myDrawer.drawLine(tex, x, y, angle, len, col, width);
    }

    public void drawLine(TextureRegion tex, Vector2 p1, Vector2 p2, Color col, float width, boolean precise) {
        this.maybeChangeAdditive(false);
        this.myDrawer.drawLine(tex, p1, p2, col, width, precise);
    }

    public void draw(ParticleEmitter emitter, TextureAtlas.AtlasRegion tex, boolean additive) {
        this.maybeChangeAdditive(additive);
        emitter.draw((Batch)this.myDrawer.getSpriteBatch());
    }

    public void drawCircle(TextureRegion tex, Vector2 center, float radius, Color col, float width, float vh) {
        this.maybeChangeAdditive(false);
        this.myDrawer.drawCircle(tex, center, radius, col, width, vh);
    }

    public void maybeChangeAdditive(boolean additive) {
        if (this.myCurrAdditive == additive) {
            return;
        }
        this.myCurrAdditive = additive;
        this.myDrawer.setAdditive(additive);
    }
}

