/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;

public class GridDrawer {
    public void draw(GameDrawer drawer, SolGame game, float gridSz, TextureAtlas.AtlasRegion tex) {
        SolCam cam = game.getCam();
        float lw = 4.0f * cam.getRealLineWidth();
        Vector2 camPos = cam.getPosition().cpy().add(game.getMapDrawer().getMapDrawPositionAdditive());
        float viewDist = cam.getViewDistance(cam.getRealZoom());
        float x = (float)((int)((camPos.x - viewDist) / gridSz)) * gridSz;
        float y = (float)((int)((camPos.y - viewDist) / gridSz)) * gridSz;
        int count = (int)(viewDist * 2.0f / gridSz);
        Color col = SolColor.UI_INACTIVE;
        for (int i = 0; i < count; ++i) {
            drawer.draw((TextureRegion)tex, lw, viewDist * 2.0f, lw / 2.0f, 0.0f, x, y, 0.0f, col);
            drawer.draw((TextureRegion)tex, lw, viewDist * 2.0f, lw / 2.0f, 0.0f, x, y, 90.0f, col);
            drawer.draw((TextureRegion)tex, lw, viewDist * 2.0f, lw / 2.0f, 0.0f, x, y, 180.0f, col);
            drawer.draw((TextureRegion)tex, lw, viewDist * 2.0f, lw / 2.0f, 0.0f, x, y, -90.0f, col);
            x += gridSz;
            y += gridSz;
        }
    }
}

