/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.MathUtils;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.Clip;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemConfig;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.maze.MazeConfig;
import org.destinationsol.game.planet.PlanetConfig;
import org.destinationsol.game.planet.SysConfig;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.GunSlot;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.game.ship.hulls.HullConfig;

public class HardnessCalc {
    public static final float SHIELD_MUL = 1.2f;

    public static float getGunMeanDps(Gun.Config gc) {
        float projHitChance;
        Clip.Config cc = gc.clipConf;
        ProjectileConfig pc = cc.projConfig;
        float projDmg = pc.dmg;
        if (pc.emTime > 0.0f) {
            projDmg = 150.0f;
        } else if (pc.density > 0.0f) {
            projDmg += 10.0f;
        }
        if (pc.guideRotationSpeed > 0.0f) {
            projHitChance = 0.9f;
        } else if (pc.zeroAbsSpeed) {
            projHitChance = 0.1f;
        } else {
            projHitChance = (pc.speed + pc.acc) / 6.0f;
            if (pc.physSize > 0.0f) {
                projHitChance += pc.physSize;
            }
            projHitChance = MathUtils.clamp((float)projHitChance, (float)0.1f, (float)1.0f);
            if (gc.fixed) {
                projHitChance *= 0.3f;
            }
        }
        float shotDmg = projDmg * projHitChance;
        return HardnessCalc.getShotDps(gc, shotDmg);
    }

    public static float getShotDps(Gun.Config gc, float shotDmg) {
        Clip.Config cc = gc.clipConf;
        int projectilesPerShot = cc.projectilesPerShot;
        if (gc.timeBetweenShots == 0.0f) {
            projectilesPerShot = cc.size;
        }
        if (projectilesPerShot > 1) {
            shotDmg *= 0.6f * (float)projectilesPerShot;
        }
        float timeBetweenShots = gc.timeBetweenShots == 0.0f ? gc.reloadTime : gc.timeBetweenShots;
        return shotDmg / timeBetweenShots;
    }

    private static float getItemCfgDps(ItemConfig ic, boolean fixed) {
        float dps = 0.0f;
        for (SolItem e : ic.examples) {
            if (!(e instanceof Gun)) {
                throw new AssertionError((Object)"all item options must be of the same type");
            }
            Gun g = (Gun)e;
            if (g.config.fixed != fixed) {
                String items = "";
                for (SolItem ex : ic.examples) {
                    items = items + ex.getDisplayName() + " ";
                }
                throw new AssertionError((Object)("all gun options must have equal fixed param: " + items));
            }
            dps += g.config.meanDps;
        }
        return dps / (float)ic.examples.size() * ic.chance;
    }

    public static float getShipConfDps(ShipConfig sc, ItemManager itemManager) {
        List<ItemConfig> parsedItems = itemManager.parseItems(sc.items);
        List<GunSlot> unusedGunSlots = sc.hull.getGunSlotList();
        float dps = 0.0f;
        Iterator<ItemConfig> itemConfigIterator = parsedItems.iterator();
        while (itemConfigIterator.hasNext() && !unusedGunSlots.isEmpty()) {
            ItemConfig itemConfig = itemConfigIterator.next();
            SolItem item = itemConfig.examples.get(0);
            if (!(item instanceof Gun)) continue;
            Gun gun = (Gun)item;
            ListIterator<GunSlot> gunSlotIterator = unusedGunSlots.listIterator();
            boolean matchingSlotFound = false;
            while (gunSlotIterator.hasNext() && !matchingSlotFound) {
                GunSlot gunSlot = (GunSlot)gunSlotIterator.next();
                if (gun.config.fixed == gunSlot.allowsRotation()) continue;
                dps += HardnessCalc.getItemCfgDps(itemConfig, gun.config.fixed);
                gunSlotIterator.remove();
                matchingSlotFound = true;
            }
        }
        return dps;
    }

    public static float getShipCfgDmgCap(ShipConfig shipConfig, ItemManager itemManager) {
        List<ItemConfig> parsed = itemManager.parseItems(shipConfig.items);
        float meanShieldLife = 0.0f;
        float meanArmorPercentage = 0.0f;
        for (ItemConfig itemConfig : parsed) {
            SolItem item = itemConfig.examples.get(0);
            if (meanShieldLife == 0.0f && item instanceof Shield) {
                for (SolItem example : itemConfig.examples) {
                    meanShieldLife += ((Shield)example).getLife();
                }
                meanShieldLife /= (float)itemConfig.examples.size();
                meanShieldLife *= itemConfig.chance;
            }
            if (meanArmorPercentage != 0.0f || !(item instanceof Armor)) continue;
            for (SolItem example : itemConfig.examples) {
                meanArmorPercentage += ((Armor)example).getPerc();
            }
            meanArmorPercentage /= (float)itemConfig.examples.size();
            meanArmorPercentage *= itemConfig.chance;
        }
        return (float)shipConfig.hull.getMaxLife() / (1.0f - meanArmorPercentage) + meanShieldLife * 1.2f;
    }

    private static float getShipConfListDps(List<ShipConfig> ships) {
        float maxDps = 0.0f;
        for (ShipConfig e : ships) {
            if (!(maxDps < e.dps)) continue;
            maxDps = e.dps;
        }
        return maxDps;
    }

    public static float getGroundDps(PlanetConfig pc, float grav) {
        float groundDps = HardnessCalc.getShipConfListDps(pc.groundEnemies);
        float bomberDps = HardnessCalc.getShipConfListDps(pc.lowOrbitEnemies);
        float res = bomberDps < groundDps ? groundDps : bomberDps;
        float gravFactor = 1.0f + grav * 0.5f;
        return res * gravFactor;
    }

    public static float getAtmDps(PlanetConfig pc) {
        return HardnessCalc.getShipConfListDps(pc.highOrbitEnemies);
    }

    public static float getMazeDps(MazeConfig c) {
        float outer = HardnessCalc.getShipConfListDps(c.outerEnemies);
        float inner = HardnessCalc.getShipConfListDps(c.innerEnemies);
        float res = inner < outer ? outer : inner;
        return res * 1.25f;
    }

    public static float getBeltDps(SysConfig c) {
        return 1.2f * HardnessCalc.getShipConfListDps(c.tempEnemies);
    }

    public static float getSysDps(SysConfig c, boolean inner) {
        return HardnessCalc.getShipConfListDps(inner ? c.innerTempEnemies : c.tempEnemies);
    }

    private static float getGunDps(Gun g) {
        if (g == null) {
            return 0.0f;
        }
        return g.config.meanDps;
    }

    public static float getShipDps(SolShip s) {
        Hull h = s.getHull();
        return HardnessCalc.getGunDps(h.getGun(false)) + HardnessCalc.getGunDps(h.getGun(true));
    }

    public static float getFarShipDps(FarShip s) {
        return HardnessCalc.getGunDps(s.getGun(false)) + HardnessCalc.getGunDps(s.getGun(true));
    }

    public static float getShipDmgCap(SolShip s) {
        return HardnessCalc.getDmgCap(s.getHull().config, s.getArmor(), s.getShield());
    }

    public static float getFarShipDmgCap(FarShip s) {
        return HardnessCalc.getDmgCap(s.getHullConfig(), s.getArmor(), s.getShield());
    }

    private static float getDmgCap(HullConfig hull, Armor armor, Shield shield) {
        float r = hull.getMaxLife();
        if (armor != null) {
            r *= 1.0f / (1.0f - armor.getPerc());
        }
        if (shield != null) {
            r += shield.getMaxLife() * 1.2f;
        }
        return r;
    }

    public static boolean isDangerous(float destDmgCap, float dps) {
        float killTime = destDmgCap / dps;
        return killTime < 5.0f;
    }

    public static boolean isDangerous(float destDmgCap, Object srcObj) {
        float dps = HardnessCalc.getShipObjDps(srcObj);
        return HardnessCalc.isDangerous(destDmgCap, dps);
    }

    public static float getShipObjDps(Object srcObj) {
        return srcObj instanceof SolShip ? HardnessCalc.getShipDps((SolShip)srcObj) : HardnessCalc.getFarShipDps((FarShip)srcObj);
    }
}

