/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.GameOptions;
import org.destinationsol.common.SolException;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.Armor;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.ui.Waypoint;

public class Hero {
    private SolShip shipHero;
    private StarPort.Transcendent transcendentHero;
    private ItemContainer mercs;
    private FarShip transcendentHeroShip;
    private boolean isTranscendent;
    private boolean isDead;
    private boolean isInvincible;
    private ArrayList<Waypoint> waypoints;

    public Hero(SolShip shipHero, SolGame solGame) {
        if (shipHero == null) {
            throw new SolException("Something is trying to create the hero when there is no ship linked to him.");
        }
        this.setSolShip(shipHero, solGame);
    }

    public void initialise(SolGame game) {
    }

    public void setTranscendent(StarPort.Transcendent transcendentHero) {
        this.transcendentHero = transcendentHero;
        this.transcendentHeroShip = transcendentHero.getShip();
        this.isTranscendent = true;
    }

    public void setSolShip(SolShip hero, SolGame solGame) {
        this.waypoints = new ArrayList();
        this.isDead = false;
        if (hero != this.shipHero && !this.isTranscendent) {
            this.mercs = new ItemContainer();
        }
        this.shipHero = hero;
        this.isTranscendent = false;
        if (this.shipHero.getTradeContainer() != null) {
            throw new SolException("Hero is not supposed to have TradeContainer.");
        }
        GameOptions options = solGame.getSolApplication().getOptions();
        if (hero.getHull() != null) {
            solGame.getSolApplication().getMusicManager().registerModuleMusic(hero.getHull().getHullConfig().getInternalName().split(":")[0], options);
        }
        solGame.getSolApplication().getMusicManager().playMusic("game", options);
    }

    public boolean isTranscendent() {
        return this.isTranscendent;
    }

    public boolean isNonTranscendent() {
        return !this.isTranscendent;
    }

    public Pilot getPilot() {
        return this.isTranscendent ? this.transcendentHeroShip.getPilot() : this.shipHero.getPilot();
    }

    public SolShip getShip() {
        if (this.isTranscendent) {
            throw new SolException("Something is trying to get a SolShip hero while the hero is in Transcendent state.");
        }
        return this.shipHero;
    }

    public SolShip getShipUnchecked() {
        return this.shipHero;
    }

    public StarPort.Transcendent getTranscendentHero() {
        if (!this.isTranscendent) {
            throw new SolException("Something is trying to get a Transcendent hero while the hero is in SolShip state.");
        }
        return this.transcendentHero;
    }

    public float getAngle() {
        return this.isTranscendent ? this.transcendentHeroShip.getAngle() : this.shipHero.getAngle();
    }

    public Shield getShield() {
        return this.isTranscendent ? this.transcendentHeroShip.getShield() : this.shipHero.getShield();
    }

    public Armor getArmor() {
        return this.isTranscendent ? this.transcendentHeroShip.getArmor() : this.shipHero.getArmor();
    }

    public ShipAbility getAbility() {
        this.assertNonTranscendent();
        return this.shipHero.getAbility();
    }

    public float getAbilityAwait() {
        this.assertNonTranscendent();
        return this.shipHero.getAbilityAwait();
    }

    public boolean canUseAbility() {
        this.assertNonTranscendent();
        return this.shipHero.canUseAbility();
    }

    public Vector2 getVelocity() {
        return this.isTranscendent ? this.transcendentHero.getVelocity() : this.shipHero.getVelocity();
    }

    public float getAcceleration() {
        this.assertNonTranscendent();
        return this.shipHero.getAcceleration();
    }

    public Vector2 getPosition() {
        return this.isTranscendent ? this.transcendentHero.getPosition() : this.shipHero.getPosition();
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void removeWaypoint(Waypoint waypoint) {
        if (this.waypoints.contains(waypoint)) {
            this.waypoints.remove(waypoint);
        }
    }

    public Hull getHull() {
        this.assertNonTranscendent();
        return this.shipHero.getHull();
    }

    public float getLife() {
        return this.isTranscendent ? this.transcendentHeroShip.getLife() : this.shipHero.getLife();
    }

    public float getRotationAcceleration() {
        this.assertNonTranscendent();
        return this.shipHero.getRotationAcceleration();
    }

    public float getRotationSpeed() {
        this.assertNonTranscendent();
        return this.shipHero.getRotationSpeed();
    }

    public float getMoney() {
        return this.isTranscendent ? this.transcendentHeroShip.getMoney() : this.shipHero.getMoney();
    }

    public void setMoney(float money) {
        this.assertNonTranscendent();
        this.shipHero.setMoney(money);
    }

    public ItemContainer getMercs() {
        this.assertNonTranscendent();
        return this.mercs;
    }

    public ItemContainer getItemContainer() {
        return this.isTranscendent ? this.transcendentHeroShip.getIc() : this.shipHero.getItemContainer();
    }

    public void die() {
        this.isDead = true;
    }

    public boolean maybeEquip(SolGame game, SolItem item, boolean equip) {
        this.assertNonTranscendent();
        return this.shipHero.maybeEquip(game, item, equip);
    }

    public boolean maybeEquip(SolGame game, SolItem item, boolean secondarySlot, boolean equip) {
        this.assertNonTranscendent();
        return this.shipHero.maybeEquip(game, item, secondarySlot, equip);
    }

    public boolean maybeUnequip(SolGame game, SolItem item, boolean equip) {
        this.assertNonTranscendent();
        return this.shipHero.maybeUnequip(game, item, equip);
    }

    public boolean maybeUnequip(SolGame game, SolItem item, boolean secondarySlot, boolean equip) {
        this.assertNonTranscendent();
        return this.shipHero.maybeUnequip(game, item, secondarySlot, equip);
    }

    private void assertNonTranscendent() {
        if (this.isTranscendent) {
            throw new SolException("Something is trying to get a property of hero that doesn't exist in transcendent state, while the hero is in transcendent state.");
        }
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isAlive() {
        return !this.isDead;
    }

    public boolean isInvincible() {
        return this.isInvincible;
    }

    public void setInvincible(boolean b) {
        this.isInvincible = b;
    }
}

