/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import org.destinationsol.common.SolColorUtil;
import org.destinationsol.game.ColorSpan;

public class HsbSpan
extends ColorSpan {
    private final float[] myHsbaStart;
    private final float[] myHsbaEnd;

    HsbSpan(float[] start, float[] end) {
        this.myHsbaStart = start;
        this.myHsbaEnd = end;
    }

    @Override
    public void set(float perc, Color col) {
        perc = MathUtils.clamp((float)perc, (float)0.0f, (float)1.0f);
        float hue = this.midVal(0, perc);
        float sat = this.midVal(1, perc);
        float br = this.midVal(2, perc);
        float a = this.midVal(3, perc);
        SolColorUtil.fromHSB(hue, sat, br, a, col);
    }

    private float midVal(int idx, float perc) {
        float s = this.myHsbaStart[idx];
        float e = this.myHsbaEnd[idx];
        return s + perc * (e - s);
    }
}

