/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.Nullable;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.BeaconHandler;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.Faction;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.FarObjData;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.Hero;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.planet.FarTileObject;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SurfaceDirection;
import org.destinationsol.game.planet.SystemBelt;
import org.destinationsol.game.planet.Tile;
import org.destinationsol.game.planet.TileObject;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.ui.Waypoint;

public class MapDrawer
implements UpdateAwareSystem {
    public static final float MIN_ZOOM = 8.0f;
    private static final float MUL_FACTOR = 2.0f;
    public static final float MAX_ZOOM = 512.0f;
    private static final float ICON_RAD = 0.02f;
    private static final float STAR_NODE_SZ = 0.003f;
    private static final float INNER_ICON_PERC = 0.6f;
    private static final float INNER_AREA_ICON_PERC = 0.7f;
    private static final float GRID_SZ = 40.0f;
    private static final float MIN_ICON_RAD_PX = 16.0f;
    private static final float MAX_SKULL_TIME = 0.75f;
    private static final float MAX_AREA_SKULL_TIME = 3.0f;
    private final TextureAtlas.AtlasRegion atmosphereTexture;
    private final TextureAtlas.AtlasRegion planetTexture;
    private final TextureAtlas.AtlasRegion planetCoreTexture;
    private final TextureAtlas.AtlasRegion starTexture;
    private final TextureAtlas.AtlasRegion mazeTexture;
    private final TextureAtlas.AtlasRegion skullTexture;
    private final TextureAtlas.AtlasRegion skullBigTexture;
    private final TextureAtlas.AtlasRegion starPortTexture;
    private final TextureAtlas.AtlasRegion beltTexture;
    private final TextureAtlas.AtlasRegion beaconAttackTexture;
    private final TextureAtlas.AtlasRegion beaconMoveTexture;
    private final TextureAtlas.AtlasRegion beaconFollowTexture;
    private final TextureAtlas.AtlasRegion iconBackground;
    private final TextureAtlas.AtlasRegion warnAreaBackground;
    private final TextureAtlas.AtlasRegion whiteTexture;
    private final TextureAtlas.AtlasRegion lineTexture;
    private final TextureAtlas.AtlasRegion waypointTexture;
    private final Color areaWarningColor;
    private final Color areaWarningBackgroundColor;
    private final float iconRadius;
    private boolean isToggled;
    private float zoom;
    private float skullTime;
    private float areaSkullTime;
    private final Vector2 mapDrawPositionAdditive = new Vector2();

    MapDrawer() {
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        this.zoom = 128.0f;
        float minIconRad = 16.0f / (float)displayDimensions.getHeight();
        this.iconRadius = 0.02f < minIconRad ? minIconRad : 0.02f;
        this.areaWarningColor = new Color(SolColor.WHITE);
        this.areaWarningBackgroundColor = new Color(SolColor.UI_WARN);
        this.warnAreaBackground = Assets.getAtlasRegion("engine:mapObjects/warnBg");
        this.atmosphereTexture = Assets.getAtlasRegion("engine:mapObjects/atm");
        this.planetTexture = Assets.getAtlasRegion("engine:mapObjects/planet");
        this.planetCoreTexture = Assets.getAtlasRegion("engine:mapObjects/planetCore");
        this.starTexture = Assets.getAtlasRegion("engine:mapObjects/star");
        this.mazeTexture = Assets.getAtlasRegion("engine:mapObjects/maze");
        this.skullBigTexture = Assets.getAtlasRegion("engine:mapObjects/skullBig");
        this.beltTexture = Assets.getAtlasRegion("engine:mapObjects/asteroids");
        this.beaconAttackTexture = Assets.getAtlasRegion("engine:mapObjects/beaconAttack");
        this.beaconMoveTexture = Assets.getAtlasRegion("engine:mapObjects/beaconMove");
        this.beaconFollowTexture = Assets.getAtlasRegion("engine:mapObjects/beaconFollow");
        this.whiteTexture = Assets.getAtlasRegion("engine:mapObjects/whiteTex");
        this.lineTexture = Assets.getAtlasRegion("engine:mapObjects/gridLine");
        this.waypointTexture = Assets.getAtlasRegion("engine:mapObjects/waypoint");
        this.iconBackground = Assets.getAtlasRegion("engine:mapObjects/hullBg");
        this.skullTexture = Assets.getAtlasRegion("engine:mapObjects/hullSkull");
        this.starPortTexture = Assets.getAtlasRegion("engine:mapObjects/hullStarport");
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public void setToggled(boolean toggled) {
        this.isToggled = toggled;
    }

    public void draw(GameDrawer drawer, SolGame game) {
        SolCam camera = game.getCam();
        float iconSz = this.getIconRadius(camera) * 2.0f;
        float starNodeW = camera.getViewHeight(this.zoom) * 0.003f;
        float viewDist = camera.getViewDistance(this.zoom);
        FactionManager factionManager = game.getFactionMan();
        Hero hero = game.getHero();
        Planet np = game.getPlanetManager().getNearestPlanet();
        Vector2 cameraPosition = camera.getPosition();
        float camAngle = camera.getAngle();
        float heroDmgCap = hero.isTranscendent() ? Float.MAX_VALUE : HardnessCalc.getShipDmgCap(hero.getShip());
        OrthographicCamera drawCamera = camera.getCamera();
        drawCamera.position.add(new Vector3(this.mapDrawPositionAdditive, 0.0f));
        drawCamera.update();
        drawer.updateMatrix(game);
        game.getGridDrawer().draw(drawer, game, 40.0f, this.lineTexture);
        this.drawPlanets(drawer, game, viewDist, np, cameraPosition, heroDmgCap, camAngle);
        this.drawMazes(drawer, game, viewDist, np, cameraPosition, heroDmgCap, camAngle);
        this.drawStarNodes(drawer, game, viewDist, cameraPosition, starNodeW);
        this.drawWaypoints(drawer, game, iconSz, viewDist);
        this.drawIcons(drawer, game, iconSz, viewDist, factionManager, hero, cameraPosition, heroDmgCap);
        if (game.getScreens().mapScreen.isPickingWaypointSpot()) {
            drawer.drawString("Click a spot for the new waypoint", drawCamera.position.x, drawCamera.position.y + this.zoom * 1.5f, 0.125f * this.zoom, true, Color.RED);
        }
        if (game.getScreens().mapScreen.isPickingWaypointToRemove()) {
            drawer.drawString("Click a waypoint to remove", drawCamera.position.x, drawCamera.position.y + this.zoom * 1.5f, 0.125f * this.zoom, true, Color.RED);
        }
        drawCamera.position.set(new Vector3(cameraPosition.x, cameraPosition.y, 0.0f));
        drawCamera.update();
    }

    public float getIconRadius(SolCam cam) {
        return cam.getViewHeight(this.zoom) * this.iconRadius;
    }

    private void drawMazes(GameDrawer drawer, SolGame game, float viewDist, Planet np, Vector2 camPos, float heroDmgCap, float camAngle) {
        ArrayList<Maze> mazes = game.getPlanetManager().getMazes();
        for (Maze maze : mazes) {
            Vector2 mazePos = maze.getPos();
            float outerRad = maze.getRadius();
            float rad = outerRad - 4.0f;
            if (viewDist < camPos.dst(mazePos) - rad) continue;
            drawer.draw((TextureRegion)this.mazeTexture, 2.0f * rad, 2.0f * rad, rad, rad, mazePos.x, mazePos.y, 45.0f, SolColor.WHITE);
            if (!HardnessCalc.isDangerous(heroDmgCap, maze.getDps())) continue;
            this.drawAreaDanger(drawer, outerRad, mazePos, 1.0f, camAngle);
        }
    }

    private void drawPlanets(GameDrawer drawer, SolGame game, float viewDist, Planet np, Vector2 camPos, float heroDmgCap, float camAngle) {
        ArrayList<SolSystem> systems = game.getPlanetManager().getSystems();
        SolCam cam = game.getCam();
        float circleWidth = cam.getRealLineWidth() * 6.0f;
        float vh = cam.getViewHeight(this.zoom);
        for (SolSystem sys : systems) {
            drawer.drawCircle((TextureRegion)this.lineTexture, sys.getPosition(), sys.getRadius(), SolColor.UI_MED, circleWidth, vh);
        }
        for (SolSystem sys : systems) {
            float dangerRad = HardnessCalc.isDangerous(heroDmgCap, sys.getDps()) ? sys.getRadius() : 0.0f;
            Vector2 sysPos = sys.getPosition();
            float rad = 78.0f;
            if (camPos.dst(sysPos) - rad < viewDist) {
                drawer.draw((TextureRegion)this.starTexture, 2.0f * rad, 2.0f * rad, rad, rad, sysPos.x, sysPos.y, 0.0f, SolColor.WHITE);
            }
            Vector2 beltIconPos = SolMath.getVec();
            ArrayList<SystemBelt> belts = sys.getBelts();
            for (SystemBelt belt : belts) {
                float beltRad = belt.getRadius();
                float halfWidth = belt.getHalfWidth().floatValue();
                int beltIconCount = (int)(0.12f * beltRad);
                for (int i = 0; i < beltIconCount; ++i) {
                    float angle = 360.0f * (float)i / (float)beltIconCount;
                    SolMath.fromAl(beltIconPos, angle, beltRad);
                    beltIconPos.add(sysPos);
                    drawer.draw((TextureRegion)this.beltTexture, 2.0f * halfWidth, 2.0f * halfWidth, halfWidth, halfWidth, beltIconPos.x, beltIconPos.y, angle * 3.0f, SolColor.WHITE);
                }
                float outerRad = beltRad + halfWidth;
                if (!(dangerRad < outerRad) || !HardnessCalc.isDangerous(heroDmgCap, belt.getDps())) continue;
                dangerRad = outerRad;
            }
            SolMath.free(beltIconPos);
            if (dangerRad < sys.getInnerRadius() && HardnessCalc.isDangerous(heroDmgCap, sys.getInnerDps())) {
                dangerRad = sys.getInnerRadius();
            }
            if (!(dangerRad > 0.0f)) continue;
            this.drawAreaDanger(drawer, dangerRad, sysPos, 0.5f, camAngle);
        }
        ArrayList<Planet> planets = game.getPlanetManager().getPlanets();
        for (Planet planet : planets) {
            float groundHeight;
            Vector2 planetPos = planet.getPosition();
            float fh = planet.getFullHeight();
            float dstToPlanetAtm = camPos.dst(planetPos) - fh;
            if (viewDist < dstToPlanetAtm) continue;
            drawer.draw((TextureRegion)this.atmosphereTexture, 2.0f * fh, 2.0f * fh, fh, fh, planetPos.x, planetPos.y, 0.0f, SolColor.UI_DARK);
            if (dstToPlanetAtm < 0.0f) {
                groundHeight = planet.getMinGroundHeight() + 0.5f;
                drawer.draw((TextureRegion)this.planetCoreTexture, 2.0f * groundHeight, 2.0f * groundHeight, groundHeight, groundHeight, planetPos.x, planetPos.y, planet.getAngle(), SolColor.WHITE);
                this.drawNpGround(drawer, game, viewDist, np, camPos);
            } else {
                groundHeight = planet.getGroundHeight();
                drawer.draw((TextureRegion)this.planetTexture, 2.0f * groundHeight, 2.0f * groundHeight, groundHeight, groundHeight, planetPos.x, planetPos.y, camAngle, SolColor.WHITE);
            }
            float f = HardnessCalc.isDangerous(heroDmgCap, planet.getGroundDamagePerSecond()) ? groundHeight + 7.0f : 0.0f;
            float dangerRad = f;
            if (!(dangerRad > 0.0f)) continue;
            this.drawAreaDanger(drawer, dangerRad, planetPos, 1.0f, camAngle);
        }
    }

    private void drawAreaDanger(GameDrawer drawer, float rad, Vector2 position, float transpMul, float angle) {
        float a;
        float perc = 2.0f * this.areaSkullTime / 3.0f;
        if (perc > 1.0f) {
            perc = 2.0f - perc;
        }
        perc = SolMath.clamp((perc - 0.5f) * 2.0f + 0.5f);
        this.areaWarningBackgroundColor.a = a = SolMath.clamp(perc * transpMul);
        this.areaWarningColor.a = a;
        drawer.draw((TextureRegion)this.warnAreaBackground, rad * 2.0f, rad * 2.0f, rad, rad, position.x, position.y, 0.0f, this.areaWarningBackgroundColor);
        drawer.draw((TextureRegion)this.skullBigTexture, (rad *= 0.7f) * 2.0f, rad * 2.0f, rad, rad, position.x, position.y, angle, this.areaWarningColor);
    }

    private void drawWaypoints(GameDrawer drawer, SolGame game, float iconSize, float viewDist) {
        ArrayList<Waypoint> waypoints = game.getHero().getWaypoints();
        for (Waypoint waypoint : waypoints) {
            if (waypoint.position.dst(game.getHero().getPosition()) > viewDist) continue;
            this.drawWaypointIcon(iconSize, waypoint.position, this.waypointTexture, drawer, waypoint.color);
        }
    }

    private void drawIcons(GameDrawer drawer, SolGame game, float iconSz, float viewDist, FactionManager factionManager, Hero hero, Vector2 camPos, float heroDmgCap) {
        String hint;
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject solObject : objs) {
            StarPort.Transcendent transcendent;
            Vector2 vector2 = solObject.getPosition();
            if (viewDist < camPos.dst(vector2)) continue;
            if (solObject instanceof SolShip) {
                SolShip solShip = (SolShip)solObject;
                hint = solShip.getPilot().getMapHint();
                if (hint == null && !DebugOptions.DETAILED_MAP) continue;
                this.drawObjIcon(iconSz, vector2, solShip.getAngle(), factionManager, hero, solShip.getPilot().getFaction(), heroDmgCap, solObject, solShip.getHull().config.getIcon(), drawer);
            }
            if (solObject instanceof StarPort) {
                StarPort starPort = (StarPort)solObject;
                this.drawStarPortIcon(drawer, iconSz, starPort.getFromPlanet(), starPort.getToPlanet());
            }
            if (!(solObject instanceof StarPort.Transcendent) || !(transcendent = (StarPort.Transcendent)solObject).getShip().getPilot().isPlayer()) continue;
            FarShip ship = game.getHero().getTranscendentHero().getShip();
            this.drawObjIcon(iconSz, vector2, transcendent.getAngle(), factionManager, hero, ship.getPilot().getFaction(), heroDmgCap, solObject, ship.getHullConfig().getIcon(), drawer);
        }
        List<FarShip> farShips = game.getObjectManager().getFarShips();
        for (FarShip farShip : farShips) {
            Vector2 vector2 = farShip.getPosition();
            if (viewDist < camPos.dst(vector2) || (hint = farShip.getPilot().getMapHint()) == null && !DebugOptions.DETAILED_MAP) continue;
            this.drawObjIcon(iconSz, vector2, farShip.getAngle(), factionManager, hero, farShip.getPilot().getFaction(), heroDmgCap, farShip, farShip.getHullConfig().getIcon(), drawer);
        }
        List<StarPort.FarStarPort> list = game.getObjectManager().getFarPorts();
        for (StarPort.FarStarPort farStarPort : list) {
            this.drawStarPortIcon(drawer, iconSz, farStarPort.getFrom(), farStarPort.getTo());
        }
        BeaconHandler beaconHandler = game.getBeaconHandler();
        BeaconHandler.Action action = beaconHandler.getCurrAction();
        if (action != null) {
            Vector2 beaconPos = beaconHandler.getPos();
            TextureAtlas.AtlasRegion icon = this.beaconMoveTexture;
            if (action == BeaconHandler.Action.ATTACK) {
                icon = this.beaconAttackTexture;
            } else if (action == BeaconHandler.Action.FOLLOW) {
                icon = this.beaconFollowTexture;
            }
            float f = iconSz * 1.5f;
        }
    }

    public void drawStarPortIcon(GameDrawer drawer, float iconSz, Planet from, Planet to) {
        float angle = SolMath.angle(from.getPosition(), to.getPosition());
        Vector2 position = StarPort.getDesiredPosition(from, to, false);
        this.drawObjIcon(iconSz, position, angle, null, null, null, -1.0f, null, this.starPortTexture, drawer);
        SolMath.free(position);
    }

    private void drawStarNodes(GameDrawer drawer, SolGame game, float viewDist, Vector2 camPos, float starNodeW) {
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject o : objs) {
            Vector2 oPos;
            if (!(o instanceof StarPort) || viewDist < camPos.dst(oPos = o.getPosition())) continue;
            StarPort sp = (StarPort)o;
            this.drawStarNode(drawer, sp.getFromPlanet(), sp.getToPlanet(), starNodeW);
        }
        List<StarPort.FarStarPort> farPorts = game.getObjectManager().getFarPorts();
        for (StarPort.FarStarPort sp : farPorts) {
            Vector2 oPos = sp.getPosition();
            if (viewDist < camPos.dst(oPos) || sp.isSecondary()) continue;
            this.drawStarNode(drawer, sp.getFrom(), sp.getTo(), starNodeW);
        }
    }

    private void drawStarNode(GameDrawer drawer, Planet from, Planet to, float starNodeW) {
        Vector2 pos1 = StarPort.getDesiredPosition(from, to, false);
        Vector2 pos2 = StarPort.getDesiredPosition(to, from, false);
        drawer.drawLine((TextureRegion)this.whiteTexture, pos1, pos2, SolColor.UI_LIGHT, starNodeW, true);
        SolMath.free(pos1);
        SolMath.free(pos2);
    }

    private void drawNpGround(GameDrawer drawer, SolGame game, float viewDist, Planet np, Vector2 camPos) {
        ObjectManager objectManager = game.getObjectManager();
        List<SolObject> objs = objectManager.getObjects();
        for (SolObject o : objs) {
            Vector2 oPos;
            TileObject to;
            if (!(o instanceof TileObject) || (to = (TileObject)o).getPlanet() != np || viewDist < camPos.dst(oPos = o.getPosition())) continue;
            float sz = to.getSz();
            this.drawPlanetTile(to.getTile(), sz, drawer, oPos, to.getAngle());
        }
        List<FarObjData> farObjs = objectManager.getFarObjs();
        for (FarObjData fod : farObjs) {
            Vector2 oPos;
            FarTileObject to;
            FarObject o = fod.fo;
            if (!(o instanceof FarTileObject) || (to = (FarTileObject)o).getPlanet() != np || viewDist < camPos.dst(oPos = o.getPosition())) continue;
            float sz = to.getSz();
            this.drawPlanetTile(to.getTile(), sz, drawer, oPos, to.getAngle());
        }
    }

    public void drawObjIcon(float iconSz, Vector2 position, float objAngle, FactionManager factionManager, @Nullable Hero hero, Faction objFac, float heroDmgCap, Object shipHack, TextureAtlas.AtlasRegion icon, Object drawerHack) {
        boolean enemy = hero != null && hero.isNonTranscendent() && factionManager.areEnemies(objFac, hero.getPilot().getFaction());
        float angle = objAngle;
        if (enemy && this.skullTime > 0.0f && HardnessCalc.isDangerous(heroDmgCap, shipHack)) {
            icon = this.skullTexture;
            angle = 0.0f;
        }
        float innerIconSz = iconSz * 0.6f;
        if (drawerHack instanceof UiDrawer) {
            UiDrawer uiDrawer = (UiDrawer)drawerHack;
            uiDrawer.draw((TextureRegion)this.iconBackground, iconSz, iconSz, iconSz / 2.0f, iconSz / 2.0f, position.x, position.y, 0.0f, enemy ? SolColor.UI_WARN : SolColor.UI_LIGHT);
            uiDrawer.draw((TextureRegion)icon, innerIconSz, innerIconSz, innerIconSz / 2.0f, innerIconSz / 2.0f, position.x, position.y, angle, SolColor.WHITE);
        } else {
            GameDrawer gameDrawer = (GameDrawer)drawerHack;
            gameDrawer.draw((TextureRegion)this.iconBackground, iconSz, iconSz, iconSz / 2.0f, iconSz / 2.0f, position.x, position.y, 0.0f, enemy ? SolColor.UI_WARN : SolColor.UI_LIGHT);
            gameDrawer.draw((TextureRegion)icon, innerIconSz, innerIconSz, innerIconSz / 2.0f, innerIconSz / 2.0f, position.x, position.y, angle, SolColor.WHITE);
        }
    }

    public void drawWaypointIcon(float iconSz, Vector2 position, TextureAtlas.AtlasRegion icon, Object drawer, Color color) {
        float innerIconSz = iconSz * 0.6f;
        if (drawer instanceof UiDrawer) {
            UiDrawer uiDrawer = (UiDrawer)drawer;
            uiDrawer.draw((TextureRegion)this.iconBackground, iconSz, iconSz, iconSz / 2.0f, iconSz / 2.0f, position.x, position.y, 0.0f, SolColor.UI_LIGHT);
            uiDrawer.draw((TextureRegion)icon, innerIconSz, innerIconSz, innerIconSz / 2.0f, innerIconSz / 2.0f, position.x, position.y, 0.0f, color);
        } else {
            GameDrawer gameDrawer = (GameDrawer)drawer;
            gameDrawer.draw((TextureRegion)this.iconBackground, iconSz, iconSz, iconSz / 2.0f, iconSz / 2.0f, position.x, position.y, 0.0f, SolColor.UI_LIGHT);
            gameDrawer.draw((TextureRegion)icon, innerIconSz, innerIconSz, innerIconSz / 2.0f, innerIconSz / 2.0f, position.x, position.y, 0.0f, color);
        }
    }

    public void changeZoom(boolean zoomIn) {
        this.zoom = zoomIn ? (this.zoom /= 2.0f) : (this.zoom *= 2.0f);
        this.zoom = MathUtils.clamp((float)this.zoom, (float)8.0f, (float)512.0f);
    }

    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void update(SolGame game, float timeStep) {
        this.skullTime += timeStep;
        if (this.skullTime > 0.75f) {
            this.skullTime = -0.75f;
        }
        this.areaSkullTime += timeStep;
        if (this.areaSkullTime > 3.0f) {
            this.areaSkullTime = 0.0f;
        }
    }

    private void drawPlanetTile(Tile t, float sz, GameDrawer drawer, Vector2 p, float angle) {
        Color col;
        float szh = 0.6f * sz;
        Color color = col = t.from == SurfaceDirection.UP && t.to == SurfaceDirection.UP ? SolColor.WHITE : SolColor.UI_OPAQUE;
        if (t.from == SurfaceDirection.FWD || t.from == SurfaceDirection.UP) {
            if (t.from == SurfaceDirection.UP) {
                drawer.draw((TextureRegion)this.whiteTexture, szh, szh, 0.0f, 0.0f, p.x, p.y, angle - 90.0f, col);
            }
            drawer.draw((TextureRegion)this.whiteTexture, szh, szh, 0.0f, 0.0f, p.x, p.y, angle, col);
        }
        if (t.to == SurfaceDirection.FWD || t.to == SurfaceDirection.UP) {
            if (t.to == SurfaceDirection.UP) {
                drawer.draw((TextureRegion)this.whiteTexture, szh, szh, 0.0f, 0.0f, p.x, p.y, angle + 180.0f, col);
            }
            drawer.draw((TextureRegion)this.whiteTexture, szh, szh, 0.0f, 0.0f, p.x, p.y, angle + 90.0f, col);
        }
    }

    public TextureAtlas.AtlasRegion getStarPortTex() {
        return this.starPortTexture;
    }

    public TextureAtlas.AtlasRegion getWaypointTexture() {
        return this.waypointTexture;
    }

    public Vector2 getMapDrawPositionAdditive() {
        return this.mapDrawPositionAdditive;
    }
}

