/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.SaveManager;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MercenarySaveLoader {
    private static final String MERC_SAVE_FILE = "mercenaries.json";
    private static final float MERCENARY_SHIP_DENSITY = -1.0f;
    private static final String NODE_HULL = "hull";
    private static final String NODE_ITEMS = "items";
    private static final String NODE_MONEY = "money";
    private static Logger logger = LoggerFactory.getLogger(MercenarySaveLoader.class);

    MercenarySaveLoader() {
    }

    List<MercItem> loadMercenariesFromSave(HullConfigManager hullConfigManager, ItemManager itemManager) {
        if (!SaveManager.resourceExists(MERC_SAVE_FILE)) {
            return Collections.emptyList();
        }
        String path = SaveManager.getResourcePath(MERC_SAVE_FILE);
        if (new File(path).length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<HashMap<String, String>> mercenaries = this.loadMercenariesDataFromJson(path);
        return this.toMercenaryItems(mercenaries, hullConfigManager, itemManager);
    }

    private ArrayList<HashMap<String, String>> loadMercenariesDataFromJson(String path) {
        ArrayList mercenaries = new ArrayList();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(path));){
            Gson gson = new Gson();
            Type type = new TypeToken<ArrayList<HashMap<String, String>>>(){}.getType();
            mercenaries = (ArrayList)gson.fromJson((Reader)bufferedReader, type);
        }
        catch (IOException e) {
            logger.error("Could not load mercenaries!", (Throwable)e);
        }
        return mercenaries;
    }

    private List<MercItem> toMercenaryItems(ArrayList<HashMap<String, String>> mercenaries, HullConfigManager hullConfigManager, ItemManager itemManager) {
        ArrayList<MercItem> mercenaryItems = new ArrayList<MercItem>();
        for (Map map : mercenaries) {
            HullConfig hullConfig = hullConfigManager.getConfig((String)map.get(NODE_HULL));
            String items = (String)map.get(NODE_ITEMS);
            int money = Integer.parseInt((String)map.get(NODE_MONEY));
            MercItem mercenaryItem = new MercItem(this.createShipConfig(hullConfig, items, money, itemManager));
            mercenaryItems.add(mercenaryItem);
        }
        return mercenaryItems;
    }

    private ShipConfig createShipConfig(HullConfig hullConfig, String items, int money, ItemManager itemManager) {
        return new ShipConfig(hullConfig, items, money, -1.0f, null, itemManager, "");
    }
}

