/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import org.destinationsol.ui.DebugCollector;

public enum MissingResourceAction {
    IGNORE("ignore"),
    WARN("warn"),
    FAIL("fail");

    public final String name;

    private MissingResourceAction(String name) {
        this.name = name;
    }

    public static MissingResourceAction forName(String name) {
        for (MissingResourceAction dt : MissingResourceAction.values()) {
            if (!dt.name.equals(name)) continue;
            return dt;
        }
        throw new AssertionError((Object)("no missing resource action for name " + name));
    }

    public void handle(String msg) {
        if (this == WARN) {
            DebugCollector.warn(msg);
        }
        if (this == FAIL) {
            throw new AssertionError((Object)msg);
        }
    }
}

