/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.ship.SolShip;

public class MountDetectDrawer
implements UpdateAwareSystem {
    private final Vector2 myNePos = new Vector2();
    private final TextureAtlas.AtlasRegion myTexture = Assets.getAtlasRegion("engine:targetDetected");
    private boolean myShouldDraw;
    private float myBaseRad;
    private float myAnimPercentage;
    private float myAngle;

    @Override
    public void update(SolGame game, float timeStep) {
        this.myShouldDraw = false;
        this.myAnimPercentage += timeStep / 2.0f;
        if (this.myAnimPercentage > 1.0f) {
            this.myAnimPercentage = 0.0f;
        }
        this.myAngle += 30.0f * timeStep;
        if (this.myAngle > 180.0f) {
            this.myAngle -= 360.0f;
        }
    }

    public void setNe(SolShip ne) {
        this.myNePos.set(ne.getPosition());
        this.myBaseRad = ne.getHull().config.getApproxRadius();
        this.myShouldDraw = true;
    }

    public void draw(GameDrawer drawer) {
        if (!this.myShouldDraw) {
            return;
        }
        float radPercentage = this.myAnimPercentage * 2.0f;
        if (radPercentage > 1.0f) {
            radPercentage = 2.0f - radPercentage;
        }
        float rad = this.myBaseRad * (1.0f + 0.5f * radPercentage);
        drawer.draw((TextureRegion)this.myTexture, rad * 2.0f, rad * 2.0f, rad, rad, this.myNePos.x, this.myNePos.y, this.myAngle, SolColor.WHITE);
    }
}

