/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.ContactFilter;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.destinationsol.common.DebugCol;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.FarObjData;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolContactFilter;
import org.destinationsol.game.SolContactListener;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableManager;
import org.destinationsol.game.drawables.FarDrawable;
import org.destinationsol.game.ship.FarShip;

public class ObjectManager
implements UpdateAwareSystem {
    private static final float MAX_RADIUS_RECALC_AWAIT = 1.0f;
    private final List<SolObject> myObjs = new ArrayList<SolObject>();
    private final List<SolObject> myToRemove = new ArrayList<SolObject>();
    private final List<SolObject> myToAdd = new ArrayList<SolObject>();
    private final List<FarObjData> myFarObjs = new ArrayList<FarObjData>();
    private final List<FarShip> myFarShips = new ArrayList<FarShip>();
    private final List<StarPort.FarStarPort> myFarPorts = new ArrayList<StarPort.FarStarPort>();
    private final World myWorld = new World(new Vector2(0.0f, 0.0f), true);
    private final Box2DDebugRenderer myDr;
    private final HashMap<SolObject, Float> myRadii;
    private float myFarEndDist;
    private float myFarBeginDist;
    private float myRadiusRecalcAwait;

    public ObjectManager(SolContactListener contactListener, FactionManager factionManager) {
        this.myWorld.setContactListener((ContactListener)contactListener);
        this.myWorld.setContactFilter((ContactFilter)new SolContactFilter(factionManager));
        this.myDr = new Box2DDebugRenderer();
        this.myRadii = new HashMap();
    }

    public boolean containsFarObj(FarObject fo) {
        for (FarObjData fod : this.myFarObjs) {
            if (fod.fo != fo) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(SolGame game, float timeStep) {
        this.addRemove(game);
        this.myWorld.step(timeStep, 6, 2);
        SolCam cam = game.getCam();
        Vector2 camPos = cam.getPosition();
        this.myFarEndDist = 1.5f * cam.getViewDistance();
        this.myFarBeginDist = 1.33f * this.myFarEndDist;
        boolean recalcRad = false;
        if (this.myRadiusRecalcAwait > 0.0f) {
            this.myRadiusRecalcAwait -= timeStep;
        } else {
            this.myRadiusRecalcAwait = 1.0f;
            recalcRad = true;
        }
        for (SolObject o : this.myObjs) {
            o.update(game);
            SolMath.checkVectorsTaken(o);
            List<Drawable> drawables = o.getDrawables();
            for (Drawable drawable : drawables) {
                drawable.update(game, o);
            }
            Hero hero = game.getHero();
            if (o.shouldBeRemoved(game)) {
                this.removeObjDelayed(o);
                if (!hero.isAlive() || !hero.isNonTranscendent() || o != hero.getShip()) continue;
                hero.die();
                continue;
            }
            if (this.isFar(o, camPos) && hero.isAlive() && hero.isNonTranscendent() && o != hero.getShip()) {
                FarObject fo = o.toFarObject();
                if (fo != null) {
                    this.addFarObjNow(fo);
                }
                this.removeObjDelayed(o);
                continue;
            }
            if (!recalcRad) continue;
            this.recalcRadius(o);
        }
        Iterator<FarObjData> it = this.myFarObjs.iterator();
        while (it.hasNext()) {
            FarObjData fod = it.next();
            FarObject fo = fod.fo;
            fo.update(game);
            SolMath.checkVectorsTaken(fo);
            if (fo.shouldBeRemoved(game)) {
                this.removeFo(it, fo);
                continue;
            }
            if (!this.isNear(fod, camPos, timeStep)) continue;
            SolObject o = fo.toObject(game);
            if (o instanceof StarPort) {
                this.addObjNow(game, o);
            } else {
                this.addObjDelayed(o);
            }
            this.removeFo(it, fo);
        }
        this.addRemove(game);
    }

    private void removeFo(Iterator<FarObjData> it, FarObject fo) {
        it.remove();
        if (fo instanceof FarShip) {
            this.myFarShips.remove(fo);
        }
        if (fo instanceof StarPort.FarStarPort) {
            this.myFarPorts.remove(fo);
        }
    }

    private void recalcRadius(SolObject o) {
        float rad = DrawableManager.radiusFromDrawables(o.getDrawables());
        this.myRadii.put(o, Float.valueOf(rad));
    }

    public float getPresenceRadius(SolObject o) {
        Float res = this.getRadius(o);
        return res.floatValue() + 8.0f * (1.0f - this.myRadiusRecalcAwait);
    }

    public Float getRadius(SolObject o) {
        Float res = this.myRadii.get(o);
        if (res == null) {
            throw new AssertionError((Object)("no radius for " + o));
        }
        return res;
    }

    private void addRemove(SolGame game) {
        for (SolObject o : this.myToRemove) {
            this.removeObjNow(game, o);
        }
        this.myToRemove.clear();
        for (SolObject o : this.myToAdd) {
            this.addObjNow(game, o);
        }
        this.myToAdd.clear();
    }

    private void removeObjNow(SolGame game, SolObject o) {
        this.myObjs.remove(o);
        this.myRadii.remove(o);
        o.onRemove(game);
        game.getDrawableManager().removeObject(o);
    }

    public void addObjNow(SolGame game, SolObject o) {
        this.myObjs.add(o);
        this.recalcRadius(o);
        game.getDrawableManager().addObject(o);
    }

    private boolean isNear(FarObjData fod, Vector2 camPos, float ts) {
        if (fod.delay > 0.0f) {
            fod.delay -= ts;
            return false;
        }
        FarObject fo = fod.fo;
        float r = fo.getRadius() * fod.depth;
        float dst = fo.getPosition().dst(camPos) - r;
        if (dst < this.myFarEndDist) {
            return true;
        }
        fod.delay = (dst - this.myFarEndDist) / 16.0f;
        return false;
    }

    private boolean isFar(SolObject o, Vector2 camPos) {
        float dst;
        float r = this.getPresenceRadius(o);
        List<Drawable> drawables = o.getDrawables();
        if (drawables != null && drawables.size() > 0) {
            r *= drawables.get((int)0).getLevel().depth;
        }
        return this.myFarBeginDist < (dst = o.getPosition().dst(camPos) - r);
    }

    public void drawDebug(GameDrawer drawer, SolGame game) {
        if (DebugOptions.DRAW_OBJ_BORDERS) {
            this.drawDebug0(drawer, game);
        }
        if (DebugOptions.OBJ_INFO) {
            this.drawDebugStrings(drawer, game);
        }
        if (DebugOptions.DRAW_PHYSIC_BORDERS) {
            drawer.end();
            this.myDr.render(this.myWorld, game.getCam().getMtx());
            drawer.begin();
        }
    }

    private void drawDebugStrings(GameDrawer drawer, SolGame game) {
        float fontSize = game.getCam().getDebugFontSize();
        for (SolObject o : this.myObjs) {
            Vector2 position = o.getPosition();
            String ds = o.toDebugString();
            if (ds == null) continue;
            drawer.drawString(ds, position.x, position.y, fontSize, true, SolColor.WHITE);
        }
        for (FarObjData fod : this.myFarObjs) {
            FarObject fo = fod.fo;
            Vector2 position = fo.getPosition();
            String ds = fo.toDebugString();
            if (ds == null) continue;
            drawer.drawString(ds, position.x, position.y, fontSize, true, SolColor.G);
        }
    }

    private void drawDebug0(GameDrawer drawer, SolGame game) {
        SolCam cam = game.getCam();
        float lineWidth = cam.getRealLineWidth();
        float vh = cam.getViewHeight();
        for (SolObject o : this.myObjs) {
            Vector2 position = o.getPosition();
            float r = this.getRadius(o).floatValue();
            drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, position, r, DebugCol.OBJ, lineWidth, vh);
            drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, position.x, position.y, o.getAngle(), r, DebugCol.OBJ, lineWidth);
        }
        for (FarObjData fod : this.myFarObjs) {
            FarObject fo = fod.fo;
            drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, fo.getPosition(), fo.getRadius(), DebugCol.OBJ_FAR, lineWidth, vh);
        }
        drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, cam.getPosition(), this.myFarBeginDist, SolColor.WHITE, lineWidth, vh);
        drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, cam.getPosition(), this.myFarEndDist, SolColor.WHITE, lineWidth, vh);
    }

    public List<SolObject> getObjects() {
        return this.myObjs;
    }

    public void doToAllCloserThan(float squaredDistance, SolObject fromObject, Consumer<SolObject> action) {
        for (SolObject obj : this.myObjs) {
            if (!(fromObject.getPosition().dst2(obj.getPosition()) < squaredDistance)) continue;
            action.accept(obj);
        }
    }

    public void addObjDelayed(SolObject p) {
        this.myToAdd.add(p);
    }

    public void removeObjDelayed(SolObject obj) {
        this.myToRemove.add(obj);
    }

    public World getWorld() {
        return this.myWorld;
    }

    public void resetDelays() {
        for (FarObjData data : this.myFarObjs) {
            data.delay = 0.0f;
        }
    }

    public List<FarObjData> getFarObjs() {
        return this.myFarObjs;
    }

    public void addFarObjNow(FarObject fo) {
        List<Drawable> drawables;
        float depth = 1.0f;
        if (fo instanceof FarDrawable && (drawables = ((FarDrawable)fo).getDrawables()) != null && drawables.size() > 0) {
            depth = drawables.get((int)0).getLevel().depth;
        }
        FarObjData fod = new FarObjData(fo, depth);
        this.myFarObjs.add(fod);
        if (fo instanceof FarShip) {
            this.myFarShips.add((FarShip)fo);
        }
        if (fo instanceof StarPort.FarStarPort) {
            this.myFarPorts.add((StarPort.FarStarPort)fo);
        }
    }

    public List<FarShip> getFarShips() {
        return this.myFarShips;
    }

    public List<StarPort.FarStarPort> getFarPorts() {
        return this.myFarPorts;
    }

    public void dispose() {
        this.myWorld.dispose();
    }
}

