/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.Faction;
import org.destinationsol.game.Hero;
import org.destinationsol.game.RespawnState;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.BeaconDestProvider;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.input.UiControlledPilot;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.ui.Waypoint;

class PlayerCreator {
    private static final int TUTORIAL_MONEY_AMOUNT = 200;
    private static final int SHIP_SPAWN_ANGLE = 0;
    private static final int SHIP_SPAWN_ROTATION_SPEED = 0;
    private static final boolean SHIP_SPAWN_HAS_REPAIRER = true;
    private static final int NUMBER_OF_TUTORIAL_ITEM_ADD_ATTEMPTS = 50;
    private static final float MAX_NUMBER_OF_TUTORIAL_ITEM_GROUPS = 12.0f;

    PlayerCreator() {
    }

    Hero createPlayer(ShipConfig shipConfig, boolean shouldSpawnOnGalaxySpawnPosition, RespawnState respawnState, SolGame game, boolean isMouseControl, boolean isNewShip) {
        Vector2 position = this.findPlayerSpawnPosition(shipConfig, shouldSpawnOnGalaxySpawnPosition, game);
        game.getCam().setPos(position);
        if (isMouseControl) {
            game.getBeaconHandler().init(game, position);
        }
        Hero hero = this.configureAndCreateHero(shipConfig, respawnState, game, isMouseControl, isNewShip, position);
        game.getObjectManager().addObjDelayed(hero.getShip());
        game.getObjectManager().resetDelays();
        return hero;
    }

    private Hero configureAndCreateHero(ShipConfig shipConfig, RespawnState respawnState, SolGame game, boolean isMouseControl, boolean isNewShip, Vector2 position) {
        Pilot pilot = this.createPilot(game, isMouseControl);
        float money = this.grantPlayerMoney(shipConfig, respawnState, game);
        HullConfig hull = this.findHullConfig(shipConfig, respawnState);
        String items = this.findItems(shipConfig, respawnState);
        String waypoints = this.findWaypoints(shipConfig, respawnState);
        boolean giveAmmo = this.shouldGiveAmmo(respawnState, isNewShip);
        Hero hero = this.createHero(position, pilot, money, hull, items, giveAmmo, game);
        this.addAndEquipItems(hero, respawnState, game);
        this.addWaypoints(hero, waypoints, respawnState, game);
        return hero;
    }

    private void addAndEquipItems(Hero hero, RespawnState respawnState, SolGame game) {
        ItemContainer itemContainer = hero.getItemContainer();
        if (!respawnState.getRespawnItems().isEmpty()) {
            this.addAndEquipRespawnItems(hero, respawnState, itemContainer, game);
        } else if (game.isTutorial()) {
            this.addRandomTutorialItems(game, itemContainer);
        }
        itemContainer.markAllAsSeen();
    }

    private void addWaypoints(Hero hero, String waypoints, RespawnState respawnState, SolGame game) {
        String[] waypointStrings;
        if (waypoints == "") {
            for (Waypoint waypoint : respawnState.getRespawnWaypoints()) {
                hero.getWaypoints().add(waypoint);
            }
            return;
        }
        for (String string : waypointStrings = waypoints.split(" ")) {
            String[] values = string.split("_");
            if (values[0] == "") continue;
            Vector2 waypointPosition = new Vector2().fromString(values[0]);
            String[] colors = values[1].split(",");
            Color color = new Color(Float.valueOf(colors[0]).floatValue(), Float.valueOf(colors[1]).floatValue(), Float.valueOf(colors[2]).floatValue(), 1.0f);
            Waypoint waypoint = new Waypoint(waypointPosition, color, game.getMapDrawer().getWaypointTexture());
            hero.addWaypoint(waypoint);
            game.getObjectManager().addObjDelayed(waypoint);
        }
    }

    private void addRandomTutorialItems(SolGame game, ItemContainer itemContainer) {
        for (int i = 0; i < 50; ++i) {
            if ((float)itemContainer.groupCount() > 12.0f) {
                return;
            }
            SolItem item = game.getItemMan().random();
            if (!this.isNoGunAndHasIcon(item, game) || !itemContainer.canAdd(item)) continue;
            itemContainer.add(item.copy());
        }
    }

    private boolean isNoGunAndHasIcon(SolItem it, SolGame game) {
        return !(it instanceof Gun) && it.getIcon(game) != null;
    }

    private void addAndEquipRespawnItems(Hero hero, RespawnState respawnState, ItemContainer itemContainer, SolGame game) {
        for (SolItem item : respawnState.getRespawnItems()) {
            itemContainer.add(item);
            this.ensurePreviouslyEquippedItemStaysEquipped(item, hero, game);
        }
    }

    private void ensurePreviouslyEquippedItemStaysEquipped(SolItem item, Hero hero, SolGame game) {
        if (item.isEquipped() > 0) {
            if (item instanceof Gun) {
                hero.maybeEquip(game, item, item.isEquipped() == 2, true);
            } else {
                hero.maybeEquip(game, item, true);
            }
        }
    }

    private Hero createHero(Vector2 position, Pilot pilot, float money, HullConfig hull, String items, boolean giveAmmo, SolGame game) {
        FarShip farShip = game.getShipBuilder().buildNewFar(game, new Vector2(position), null, 0.0f, 0.0f, pilot, items, hull, null, true, money, null, giveAmmo);
        return new Hero(farShip.toObject(game), game);
    }

    private boolean shouldGiveAmmo(RespawnState respawnState, boolean isNewShip) {
        return isNewShip && respawnState.getRespawnItems().isEmpty();
    }

    private String findItems(ShipConfig shipConfig, RespawnState respawnState) {
        if (!respawnState.getRespawnItems().isEmpty()) {
            return "";
        }
        return shipConfig.getItems();
    }

    private String findWaypoints(ShipConfig shipConfig, RespawnState respawnState) {
        if (!respawnState.getRespawnWaypoints().isEmpty()) {
            return "";
        }
        return shipConfig.getWaypoints();
    }

    private HullConfig findHullConfig(ShipConfig shipConfig, RespawnState respawnState) {
        if (respawnState.getRespawnHull() != null) {
            return respawnState.getRespawnHull();
        }
        return shipConfig.getHull();
    }

    private float grantPlayerMoney(ShipConfig shipConfig, RespawnState respawnState, SolGame game) {
        if (respawnState.getRespawnMoney() != 0.0f) {
            return respawnState.getRespawnMoney();
        }
        if (game.isTutorial()) {
            return 200.0f;
        }
        return shipConfig.getMoney();
    }

    private Pilot createPilot(SolGame game, boolean isMouseControl) {
        if (isMouseControl) {
            return new AiPilot(new BeaconDestProvider(), true, Faction.LAANI, false, "you", 5.4f);
        }
        return new UiControlledPilot(game.getScreens().mainGameScreen);
    }

    private Vector2 findPlayerSpawnPosition(ShipConfig shipConfig, boolean shouldSpawnOnGalaxySpawnPosition, SolGame game) {
        if (shouldSpawnOnGalaxySpawnPosition) {
            return game.getGalaxyFiller().getPlayerSpawnPos(game);
        }
        return shipConfig.getSpawnPos();
    }
}

