/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import org.destinationsol.assets.json.Validator;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.item.ItemManager;
import org.json.JSONObject;

public class PlayerSpawnConfig {
    final ShipConfig mainStation;
    final ShipConfig godShipConfig;
    final ShipConfig shipConfig;

    PlayerSpawnConfig(ShipConfig shipConfig, ShipConfig mainStation, ShipConfig godShipConfig) {
        this.shipConfig = shipConfig;
        this.mainStation = mainStation;
        this.godShipConfig = godShipConfig;
    }

    public static PlayerSpawnConfig load(HullConfigManager hullConfigs, ItemManager itemManager) {
        JSONObject rootNode = Validator.getValidatedJSON("engine:playerSpawnConfig", "engine:schemaPlayerSpawnConfig");
        JSONObject playerNode = rootNode.getJSONObject("player");
        ShipConfig shipConfig = ShipConfig.load(hullConfigs, playerNode.has("ship") ? playerNode.getJSONObject("ship") : null, itemManager);
        ShipConfig godShipConfig = ShipConfig.load(hullConfigs, playerNode.has("godModeShip") ? playerNode.getJSONObject("godModeShip") : null, itemManager);
        ShipConfig mainStation = ShipConfig.load(hullConfigs, rootNode.has("mainStation") ? rootNode.getJSONObject("mainStation") : null, itemManager);
        return new PlayerSpawnConfig(shipConfig, mainStation, godShipConfig);
    }
}

