/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.IniReader;
import org.destinationsol.common.SolRandom;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.Hero;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.WorldConfig;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.ui.Waypoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.module.sandbox.API;

@API
public class SaveManager {
    private static Logger logger = LoggerFactory.getLogger(SaveManager.class);

    protected SaveManager() {
    }

    public static void writeShips(HullConfig hull, float money, List<SolItem> itemsList, Hero hero, HullConfigManager hullConfigManager) {
        String hullName = hullConfigManager.getName(hull);
        SaveManager.writeMercs(hero, hullConfigManager);
        String items = SaveManager.itemsToString(itemsList);
        Vector2 pos = hero.getPosition();
        String waypoints = SaveManager.waypointsToString(hero.getWaypoints());
        IniReader.write("prevShip.ini", "hull", hullName, "money", (int)money, "items", items, "x", Float.valueOf(pos.x), "y", Float.valueOf(pos.y), "waypoints", waypoints, "version", "2.0.0");
    }

    private static String waypointsToString(ArrayList<Waypoint> waypoints) {
        StringBuilder sb = new StringBuilder();
        for (Waypoint waypoint : waypoints) {
            sb.append(waypoint.position.toString());
            sb.append('_');
            sb.append(waypoint.color.r);
            sb.append(',');
            sb.append(waypoint.color.g);
            sb.append(',');
            sb.append(waypoint.color.b);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String itemsToString(List<SolItem> items) {
        StringBuilder sb = new StringBuilder();
        for (SolItem i : items) {
            sb.append(i.getCode());
            if (i.isEquipped() > 0) {
                sb.append("-").append(i.isEquipped());
            }
            sb.append(" ");
            if (!(i instanceof Gun)) continue;
            Gun g = (Gun)i;
            if (g.ammo <= 0 && !(g.reloadAwait > 0.0f) || g.config.clipConf.infinite) continue;
            sb.append(g.config.clipConf.code).append(" ");
        }
        return sb.toString();
    }

    private static void writeMercs(Hero hero, HullConfigManager hullConfigManager) {
        ItemContainer mercenaries = hero.getMercs();
        ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
        for (List<SolItem> group : mercenaries) {
            for (SolItem item : group) {
                SolShip merc = ((MercItem)item).getSolShip();
                String hullName = hullConfigManager.getName(merc.getHull().config);
                int money = (int)merc.getMoney();
                ArrayList<SolItem> itemsList = new ArrayList<SolItem>();
                for (List<SolItem> itemGroup : merc.getItemContainer()) {
                    for (SolItem itemInGroup : itemGroup) {
                        itemsList.add(0, itemInGroup);
                    }
                }
                String items = SaveManager.itemsToString(itemsList);
                JsonObject json = new JsonObject();
                json.addProperty("hull", hullName);
                json.addProperty("money", (Number)money);
                json.addProperty("items", items);
                jsons.add(json);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String stringToWrite = gson.toJson(jsons);
        try {
            PrintWriter writer = new PrintWriter(SaveManager.getResourcePath("mercenaries.json"), "UTF-8");
            writer.write(stringToWrite);
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            logger.error("Could not save mercenaries, " + e.getMessage());
        }
    }

    public static String getResourcePath(String fileName) {
        if (DebugOptions.DEV_ROOT_PATH != null) {
            return DebugOptions.DEV_ROOT_PATH + fileName;
        }
        return Gdx.files.getLocalStoragePath() + "/" + fileName;
    }

    public static boolean resourceExists(String fileName) {
        String path = SaveManager.getResourcePath(fileName);
        return new FileHandle(new File(path)).exists();
    }

    public static boolean hasPreviousCompatibleShip() {
        if (!SaveManager.resourceExists("prevShip.ini")) {
            return false;
        }
        IniReader reader = new IniReader("prevShip.ini", null);
        String saveMajorVersion = reader.getString("version", "").split("\\.")[0];
        String gameMajorVersion = "2.0.0".split("\\.")[0];
        return saveMajorVersion.equals(gameMajorVersion);
    }

    public static ShipConfig readShip(HullConfigManager hullConfigs, ItemManager itemManager) {
        IniReader ir = new IniReader("prevShip.ini", null);
        String hullName = ir.getString("hull", null);
        if (hullName == null) {
            return null;
        }
        HullConfig hull = hullConfigs.getConfig(hullName);
        if (hull == null) {
            return null;
        }
        int money = ir.getInt("money", 0);
        String itemsStr = ir.getString("items", "");
        float x = ir.getFloat("x", 0.0f);
        float y = ir.getFloat("y", 0.0f);
        Vector2 spawnPos = new Vector2(x, y);
        String waypoints = ir.getString("waypoints", "");
        return new ShipConfig(hull, itemsStr, money, 1.0f, null, itemManager, spawnPos, waypoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveWorld(int numberOfSystems) {
        Long seed = SolRandom.getSeed();
        String fileName = SaveManager.getResourcePath("world.json");
        JsonObject world = new JsonObject();
        world.addProperty("seed", (Number)seed);
        world.addProperty("systems", (Number)numberOfSystems);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String stringToWrite = gson.toJson((JsonElement)world);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(fileName, "UTF-8");
            writer.write(stringToWrite);
            logger.debug("Successfully saved the world file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorldConfig loadWorld() {
        if (SaveManager.resourceExists("world.json")) {
            WorldConfig config = new WorldConfig();
            JsonReader reader = null;
            try {
                reader = new JsonReader((Reader)new FileReader(SaveManager.getResourcePath("world.json")));
                reader.setLenient(true);
                JsonObject world = new JsonParser().parse(reader).getAsJsonObject();
                if (world.has("seed")) {
                    config.setSeed(world.get("seed").getAsLong());
                }
                if (world.has("systems")) {
                    config.setNumberOfSystems(world.get("systems").getAsInt());
                }
                logger.debug("Successfully loaded the world file");
                WorldConfig worldConfig = config;
                return worldConfig;
            }
            catch (FileNotFoundException e) {
                logger.error("Cannot find world file", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

