/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;

public class Shard
implements SolObject {
    private final Body body;
    private final Vector2 position;
    private final ArrayList<Drawable> drawables;
    private final float mass;
    private float angle;

    Shard(Body body, ArrayList<Drawable> drawables) {
        this.drawables = drawables;
        this.body = body;
        this.position = new Vector2();
        this.mass = this.body.getMass();
        this.setParamsFromBody();
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return this.body.getLinearVelocity();
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public Boolean isMetal() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public void update(SolGame game) {
        this.setParamsFromBody();
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.angle = this.body.getAngle() * 57.295776f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
        this.body.getWorld().destroyBody(this.body);
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
    }

    @Override
    public boolean receivesGravity() {
        return true;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        if (acc) {
            force.scl(this.mass);
        }
        this.body.applyForceToCenter(force, true);
    }
}

