/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.Shard;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;

public class ShardBuilder {
    public static final float MIN_SCALE = 0.07f;
    public static final float MAX_SCALE = 0.12f;
    public static final float SIZE_TO_SHARD_COUNT = 13.0f;
    private static final float MAX_ROT_SPD = 5.0f;
    private static final float MAX_SPD = 4.0f;
    private final CollisionMeshLoader myCollisionMeshLoader = new CollisionMeshLoader("engine:miscCollisionMeshes");
    private final List<TextureAtlas.AtlasRegion> myTextures = Assets.listTexturesMatching("engine:shard_.*");

    public void buildExplosionShards(SolGame game, Vector2 position, Vector2 baseVelocity, float size) {
        int count = (int)(size * 13.0f);
        for (int i = 0; i < count; ++i) {
            Shard s = this.build(game, position, baseVelocity, size);
            game.getObjectManager().addObjDelayed(s);
        }
    }

    public Shard build(SolGame game, Vector2 basePos, Vector2 baseVelocity, float size) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        float scale = SolRandom.randomFloat(0.07f, 0.12f);
        TextureAtlas.AtlasRegion tex = SolRandom.randomElement(this.myTextures);
        float velocityAngle = SolRandom.randomFloat(180.0f);
        Vector2 position = new Vector2();
        SolMath.fromAl(position, velocityAngle, SolRandom.randomFloat(size));
        position.add(basePos);
        Body body = this.myCollisionMeshLoader.getBodyAndSprite(game.getObjectManager().getWorld(), tex, scale, BodyDef.BodyType.DynamicBody, position, SolRandom.randomFloat(180.0f), drawables, 3.0f, DrawableLevel.PROJECTILES);
        body.setAngularVelocity(SolRandom.randomFloat(5.0f));
        Vector2 velocity = SolMath.fromAl(velocityAngle, SolRandom.randomFloat(4.0f));
        velocity.add(baseVelocity);
        body.setLinearVelocity(velocity);
        SolMath.free(velocity);
        Shard shard = new Shard(body, drawables);
        body.setUserData((Object)shard);
        return shard;
    }
}

