/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONArray;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class ShipConfig {
    public final HullConfig hull;
    public final String items;
    public final int money;
    public final float density;
    public final ShipConfig guard;
    public final float dps;
    public Vector2 spawnPos;
    private final String waypoints;

    public ShipConfig(HullConfig hull, String items, int money, float density, ShipConfig guard, ItemManager itemManager, String waypoints) {
        this.hull = hull;
        this.items = items;
        this.money = money;
        this.density = density;
        this.guard = guard;
        this.waypoints = waypoints;
        this.dps = HardnessCalc.getShipConfDps(this, itemManager);
    }

    public ShipConfig(HullConfig hull, String items, int money, float density, ShipConfig guard, ItemManager itemManager, Vector2 spawnPos, String waypoints) {
        this(hull, items, money, density, guard, itemManager, waypoints);
        this.spawnPos = spawnPos;
    }

    public Vector2 getSpawnPos() {
        return this.spawnPos;
    }

    public int getMoney() {
        return this.money;
    }

    public HullConfig getHull() {
        return this.hull;
    }

    public String getItems() {
        return this.items;
    }

    public String getWaypoints() {
        return this.waypoints;
    }

    public static ArrayList<ShipConfig> loadList(JSONArray shipListJson, HullConfigManager hullConfigs, ItemManager itemManager) {
        ArrayList<ShipConfig> res = new ArrayList<ShipConfig>();
        if (shipListJson == null) {
            return res;
        }
        for (int i = 0; i < shipListJson.length(); ++i) {
            JSONObject shipNode = shipListJson.getJSONObject(i);
            ShipConfig c = ShipConfig.load(hullConfigs, shipNode, itemManager);
            res.add(c);
        }
        return res;
    }

    public static ShipConfig load(HullConfigManager hullConfigs, String shipName, ItemManager itemManager) {
        Set<ResourceUrn> configUrnList = Assets.getAssetHelper().listAssets(Json.class, "playerSpawnConfig");
        ShipConfig shipConfig = null;
        for (ResourceUrn configUrn : configUrnList) {
            JSONObject rootNode = Validator.getValidatedJSON(configUrn.toString(), "engine:schemaPlayerSpawnConfig");
            if (rootNode.keySet().contains(shipName) && rootNode.get(shipName) instanceof JSONObject) {
                shipConfig = ShipConfig.load(hullConfigs, rootNode.has(shipName) ? rootNode.getJSONObject(shipName) : null, itemManager);
            }
            if (shipConfig == null) continue;
            break;
        }
        return shipConfig;
    }

    public static ShipConfig load(HullConfigManager hullConfigs, JSONObject rootNode, ItemManager itemManager) {
        if (rootNode == null) {
            return null;
        }
        String hullName = rootNode.getString("hull");
        HullConfig hull = hullConfigs.getConfig(hullName);
        ShipConfig guard = rootNode.has("guard") ? ShipConfig.load(hullConfigs, rootNode.getJSONObject("guard"), itemManager) : null;
        String items = rootNode.getString("items");
        int money = rootNode.optInt("money", 0);
        float density = (float)rootNode.optDouble("density", -1.0);
        return new ShipConfig(hull, items, money, density, guard, itemManager, "");
    }
}

