/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CamRotStrategy;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.Hero;
import org.destinationsol.game.MapDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.screens.MainGameScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.ui.DisplayDimensions;

public class SolCam
implements UpdateAwareSystem {
    public static final float CAM_ROT_SPD = 90.0f;
    private static final float VIEWPORT_HEIGHT = 5.0f;
    private static final float MAX_ZOOM_SPD = 5.0f;
    private static final float MED_ZOOM_SPD = 3.0f;
    private static final float ZOOM_CHG_SPD = 0.1f;
    private static final float MOVE_SPD = 3.0f;
    private static final float MAX_SHAKE = 0.07f;
    private static final float SHAKE_DAMP = 0.07f;
    public static boolean DIRECT_CAM_CONTROL = false;
    private final CamRotStrategy myCamRotStrategy;
    private final OrthographicCamera myCam;
    private final ScreenViewport viewport;
    private final Vector3 myTmpVec;
    private float myPrevHeroLife;
    private Hull previousHeroHull;
    private float myShake;
    private float myAngle;
    private float myZoom;
    private Vector2 position;
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;

    public SolCam() {
        this.myCamRotStrategy = new CamRotStrategy.ToPlanet();
        this.myCam = new OrthographicCamera(5.0f * this.displayDimensions.getRatio(), -5.0f);
        this.viewport = new ScreenViewport((Camera)this.myCam);
        this.myZoom = this.calcZoom(2.8f);
        this.position = new Vector2();
        this.myTmpVec = new Vector3();
    }

    public Matrix4 getMtx() {
        return this.myCam.combined;
    }

    @Override
    public void update(SolGame game, float timeStep) {
        if (game.isPaused()) {
            this.updateMapZoom(game, timeStep);
            return;
        }
        Hero hero = game.getHero();
        float life = hero.getLife();
        Hull hull = null;
        if (hero.isNonTranscendent()) {
            hull = hero.getHull();
        }
        if (hero.isDead() || DIRECT_CAM_CONTROL) {
            this.applyInput(game);
        } else {
            Vector2 heroPos = hero.getPosition();
            if (this.myZoom * 5.0f < heroPos.dst(this.position)) {
                this.position.set(heroPos);
                game.getObjectManager().resetDelays();
            } else {
                Vector2 moveDiff = SolMath.getVec(hero.getVelocity());
                moveDiff.scl(timeStep);
                this.position.add(moveDiff);
                SolMath.free(moveDiff);
                float moveSpeed = 3.0f * timeStep;
                this.position.x = SolMath.approach(this.position.x, heroPos.x, moveSpeed);
                this.position.y = SolMath.approach(this.position.y, heroPos.y, moveSpeed);
            }
        }
        if (life < this.myPrevHeroLife && hull == this.previousHeroHull) {
            float shakeDiff = 0.007f * (this.myPrevHeroLife - life);
            this.myShake = SolMath.approach(this.myShake, 0.07f, shakeDiff);
        } else {
            this.myShake = SolMath.approach(this.myShake, 0.0f, 0.07f * timeStep);
        }
        this.myPrevHeroLife = life;
        this.previousHeroHull = hull;
        Vector2 position = SolMath.fromAl(SolRandom.randomFloat(180.0f), this.myShake);
        position.add(this.position);
        this.applyPos(position.x, position.y);
        SolMath.free(position);
        float desiredAngle = this.myCamRotStrategy.getRotation(this.position, game);
        float rotationSpeed = 90.0f * timeStep;
        this.myAngle = SolMath.approachAngle(this.myAngle, desiredAngle, rotationSpeed);
        this.applyAngle();
        this.updateMapZoom(game, timeStep);
    }

    private void updateMapZoom(SolGame game, float timeStep) {
        float desiredViewDistance = this.getDesiredViewDistance(game);
        float desiredZoom = this.calcZoom(desiredViewDistance);
        this.myZoom = SolMath.approach(this.myZoom, desiredZoom, 0.1f * timeStep);
        this.applyZoom(game.getMapDrawer());
        this.myCam.update();
        this.viewport.update(this.displayDimensions.getWidth(), -this.displayDimensions.getHeight());
        this.viewport.setUnitsPerPixel(1.0f / ((float)this.displayDimensions.getHeight() / 5.0f));
    }

    private float getDesiredViewDistance(SolGame game) {
        Hero hero = game.getHero();
        if (hero.isAlive() && hero.isTranscendent()) {
            return 4.5f;
        }
        if (hero.isDead()) {
            return 2.8f;
        }
        float speed = hero.getVelocity().len();
        float desiredViewDistance = 4.5f;
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet(this.position);
        if (nearestPlanet.getFullHeight() < nearestPlanet.getPosition().dst(this.position) && 5.0f < speed) {
            desiredViewDistance = 8.6f;
        } else if (nearestPlanet.isNearGround(this.position) && speed < 3.0f) {
            desiredViewDistance = 2.8f;
        }
        return desiredViewDistance += hero.getHull().config.getApproxRadius();
    }

    private float calcZoom(float vd) {
        float h = vd * SolMath.sqrt(2.0f);
        return h / 5.0f;
    }

    private void applyZoom(MapDrawer mapDrawer) {
        if (mapDrawer.isToggled()) {
            this.myCam.zoom = mapDrawer.getZoom();
            return;
        }
        if (DebugOptions.ZOOM_OVERRIDE != 0.0f) {
            this.myCam.zoom = DebugOptions.ZOOM_OVERRIDE;
            return;
        }
        this.myCam.zoom = this.myZoom;
    }

    public void applyPos(float posX, float posY) {
        this.myCam.position.set(posX, posY, 0.0f);
        this.myCam.update();
    }

    private void applyInput(SolGame game) {
        MainGameScreen screen = game.getScreens().mainGameScreen;
        boolean d = screen.isCameraDown();
        boolean u = screen.isCameraUp();
        boolean l = screen.isCameraLeft();
        boolean r = screen.isCameraRight();
        Vector2 v = SolMath.getVec();
        if (l != r) {
            v.x = SolMath.toInt(r);
        }
        if (d != u) {
            v.y = SolMath.toInt(d);
        }
        v.scl(3.0f * game.getTimeStep());
        SolMath.rotate(v, this.myAngle);
        this.position.add(v);
        SolMath.free(v);
    }

    private void applyAngle() {
        Vector2 v = SolMath.getVec(0.0f, 1.0f);
        SolMath.rotate(v, this.myAngle);
        this.myCam.up.set(v.x, v.y, 0.0f);
        SolMath.free(v);
    }

    public float getViewDistance() {
        return this.getViewDistance(this.myZoom);
    }

    public float getViewDistance(float zoom) {
        float r = this.myCam.viewportWidth / this.myCam.viewportHeight;
        return 2.5f * SolMath.sqrt(1.0f + r * r) * zoom;
    }

    public float getAngle() {
        return this.myAngle;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public void setPos(Vector2 position) {
        this.position.set(position);
    }

    public void drawDebug(GameDrawer drawer) {
        float hOver2 = 5.0f * this.myZoom / 2.0f;
        float wOver2 = hOver2 * this.displayDimensions.getRatio();
        Vector2 dr = SolMath.getVec(wOver2, hOver2);
        SolMath.rotate(dr, this.myAngle);
        Vector2 dl = SolMath.getVec(-wOver2, hOver2);
        SolMath.rotate(dl, this.myAngle);
        Vector2 ul = SolMath.getVec(dr);
        ul.scl(-1.0f);
        Vector2 ur = SolMath.getVec(dl);
        ur.scl(-1.0f);
        dr.add(this.position);
        dl.add(this.position);
        ul.add(this.position);
        ur.add(this.position);
        float lw = this.getRealLineWidth();
        drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, dr, dl, SolColor.WHITE, lw, false);
        drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, dl, ul, SolColor.WHITE, lw, false);
        drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, ul, ur, SolColor.WHITE, lw, false);
        drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, ur, dr, SolColor.WHITE, lw, false);
        SolMath.free(dr);
        SolMath.free(dl);
        SolMath.free(ul);
        SolMath.free(ur);
    }

    public float getRealLineWidth() {
        return this.getViewHeight(this.myCam.zoom) / (float)Gdx.graphics.getHeight();
    }

    public float getViewHeight() {
        return this.getViewHeight(this.myZoom);
    }

    public float getViewHeight(float zoom) {
        float r = -this.myCam.viewportHeight * zoom;
        if (r < 0.0f) {
            throw new AssertionError((Object)"negative view height");
        }
        return r;
    }

    public float getViewWidth() {
        float r = this.myCam.viewportWidth * this.myZoom;
        if (r < 0.0f) {
            throw new AssertionError((Object)"negative view width");
        }
        return r;
    }

    public float getRealZoom() {
        return this.myCam.zoom;
    }

    public OrthographicCamera getCamera() {
        return this.myCam;
    }

    public boolean isVisible(Vector2 position) {
        Vector2 rp = SolMath.toRel(position, this.myAngle, this.position);
        boolean res = this.isRelVisible(rp);
        SolMath.free(rp);
        return res;
    }

    public boolean isRelVisible(Vector2 rp) {
        float wHalf = this.getViewWidth() / 2.0f;
        if (wHalf < SolMath.abs(rp.x)) {
            return false;
        }
        float hHalf = this.getViewHeight() / 2.0f;
        return !(hHalf < SolMath.abs(rp.y));
    }

    public float getDebugFontSize() {
        return 0.04f * this.getRealZoom();
    }

    public void screenToWorld(Vector2 position) {
        this.myTmpVec.set(position, 0.0f);
        this.myCam.unproject(this.myTmpVec);
        position.x = this.myTmpVec.x;
        position.y = this.myTmpVec.y;
    }

    public Vector2 worldToScreen(SolShip ship) {
        Vector2 distanceDifference = new Vector2(this.getPosition());
        distanceDifference.sub(ship.getPosition());
        distanceDifference.x /= this.getViewWidth();
        distanceDifference.x = 0.5f - distanceDifference.x;
        distanceDifference.y /= this.getViewHeight();
        distanceDifference.y = 0.5f - distanceDifference.y;
        return distanceDifference;
    }

    public boolean isMatrixValid() {
        for (float i : this.myCam.combined.val) {
            if (Float.isFinite(i)) continue;
            return false;
        }
        return true;
    }
}

