/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Manifold;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.projectile.Projectile;

public class SolContactListener
implements ContactListener {
    private final SolGame myGame;

    public SolContactListener(SolGame game) {
        this.myGame = game;
    }

    public void beginContact(Contact contact) {
        SolObject oA = (SolObject)contact.getFixtureA().getBody().getUserData();
        SolObject oB = (SolObject)contact.getFixtureB().getBody().getUserData();
        boolean aIsProj = oA instanceof Projectile;
        if (!aIsProj && !(oB instanceof Projectile)) {
            return;
        }
        Projectile proj = (Projectile)(aIsProj ? oA : oB);
        SolObject o = aIsProj ? oB : oA;
        proj.setObstacle(o, this.myGame);
    }

    public void endContact(Contact contact) {
    }

    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    public void postSolve(Contact contact, ContactImpulse impulse) {
        SolObject soa = (SolObject)contact.getFixtureA().getBody().getUserData();
        SolObject sob = (SolObject)contact.getFixtureB().getBody().getUserData();
        if (soa instanceof Projectile && ((Projectile)soa).getConfig().density <= 0.0f) {
            return;
        }
        if (sob instanceof Projectile && ((Projectile)sob).getConfig().density <= 0.0f) {
            return;
        }
        float absImpulse = this.calcAbsImpulse(impulse);
        Vector2 collPos = contact.getWorldManifold().getPoints()[0];
        soa.handleContact(sob, absImpulse, this.myGame, collPos);
        sob.handleContact(soa, absImpulse, this.myGame, collPos);
        this.myGame.getSpecialSounds().playColl(this.myGame, absImpulse, soa, collPos);
        this.myGame.getSpecialSounds().playColl(this.myGame, absImpulse, sob, collPos);
    }

    private float calcAbsImpulse(ContactImpulse impulse) {
        float absImpulse = 0.0f;
        int pointCount = impulse.getCount();
        float[] normImpulses = impulse.getNormalImpulses();
        for (int i = 0; i < pointCount; ++i) {
            float normImpulse = normImpulses[i];
            if (!(absImpulse < (normImpulse = SolMath.abs(normImpulse)))) continue;
            absImpulse = normImpulse;
        }
        return absImpulse;
    }
}

