/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.destinationsol.CommonDrawer;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.assets.sound.SpecialSounds;
import org.destinationsol.common.DebugCol;
import org.destinationsol.common.SolException;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.entitysystem.EntitySystemManager;
import org.destinationsol.entitysystem.SerialisationManager;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.AbilityCommonConfigs;
import org.destinationsol.game.BeaconHandler;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.FarObjData;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.GalaxyFiller;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.GridDrawer;
import org.destinationsol.game.Hero;
import org.destinationsol.game.MapDrawer;
import org.destinationsol.game.MercenarySaveLoader;
import org.destinationsol.game.MountDetectDrawer;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.PlayerCreator;
import org.destinationsol.game.RespawnState;
import org.destinationsol.game.SaveManager;
import org.destinationsol.game.ShardBuilder;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolContactListener;
import org.destinationsol.game.SolNames;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.WorldConfig;
import org.destinationsol.game.asteroid.AsteroidBuilder;
import org.destinationsol.game.attributes.RegisterUpdateSystem;
import org.destinationsol.game.chunk.ChunkManager;
import org.destinationsol.game.context.Context;
import org.destinationsol.game.drawables.DrawableDebugger;
import org.destinationsol.game.drawables.DrawableManager;
import org.destinationsol.game.farBg.FarBackgroundManagerOld;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.LootBuilder;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.EffectTypes;
import org.destinationsol.game.particle.PartMan;
import org.destinationsol.game.particle.SpecialEffects;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetManager;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.screens.GameScreens;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.ShipBuilder;
import org.destinationsol.game.ship.SloMo;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.mercenary.MercenaryUtils;
import org.destinationsol.modules.ModuleManager;
import org.destinationsol.ui.DebugCollector;
import org.destinationsol.ui.TutorialManager;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.ui.Waypoint;
import org.terasology.gestalt.entitysystem.entity.EntityRef;

public class SolGame {
    private final GameScreens gameScreens;
    private final SolCam camera;
    private final ObjectManager objectManager;
    private final boolean isTutorial;
    private final SolApplication solApplication;
    private final DrawableManager drawableManager;
    private final PlanetManager planetManager;
    private final ChunkManager chunkManager;
    private final PartMan partMan;
    private final AsteroidBuilder asteroidBuilder;
    private final LootBuilder lootBuilder;
    private final ShipBuilder shipBuilder;
    private final HullConfigManager hullConfigManager;
    private final GridDrawer gridDrawer;
    private final FarBackgroundManagerOld farBackgroundManagerOld;
    private final FactionManager factionManager;
    private final MapDrawer mapDrawer;
    private final ShardBuilder shardBuilder;
    private final ItemManager itemManager;
    private final StarPort.Builder starPortBuilder;
    private final OggSoundManager soundManager;
    private final DrawableDebugger drawableDebugger;
    private final SpecialSounds specialSounds;
    private final SpecialEffects specialEffects;
    private final GameColors gameColors;
    private final BeaconHandler beaconHandler;
    private final MountDetectDrawer mountDetectDrawer;
    private final TutorialManager tutorialManager;
    private final GalaxyFiller galaxyFiller;
    private Hero hero;
    private float timeStep;
    private float time;
    private boolean paused;
    private float timeFactor;
    private RespawnState respawnState;
    private SortedMap<Integer, List<UpdateAwareSystem>> onPausedUpdateSystems;
    private SortedMap<Integer, List<UpdateAwareSystem>> updateSystems;

    public SolGame(String shipName, boolean isTutorial, boolean isNewGame, CommonDrawer commonDrawer, Context context, WorldConfig worldConfig) {
        this.isTutorial = isTutorial;
        this.solApplication = context.get(SolApplication.class);
        ModuleManager moduleManager = context.get(ModuleManager.class);
        GameDrawer drawer = new GameDrawer(commonDrawer);
        this.gameColors = new GameColors();
        this.soundManager = this.solApplication.getSoundManager();
        this.specialSounds = new SpecialSounds(this.soundManager);
        this.drawableManager = new DrawableManager(drawer);
        this.camera = new SolCam();
        this.gameScreens = new GameScreens(this.solApplication, context);
        if (isTutorial) {
            this.tutorialManager = new TutorialManager(this.gameScreens, this.solApplication.isMobile(), this.solApplication.getOptions(), this);
            context.put(TutorialManager.class, this.tutorialManager);
        } else {
            this.tutorialManager = null;
        }
        this.farBackgroundManagerOld = new FarBackgroundManagerOld();
        this.shipBuilder = new ShipBuilder();
        EffectTypes effectTypes = new EffectTypes();
        this.specialEffects = new SpecialEffects(effectTypes, this.gameColors);
        this.itemManager = new ItemManager(this.soundManager, effectTypes, this.gameColors);
        AbilityCommonConfigs abilityCommonConfigs = new AbilityCommonConfigs(effectTypes, this.gameColors, this.soundManager);
        this.hullConfigManager = new HullConfigManager(this.itemManager, abilityCommonConfigs);
        SolNames solNames = new SolNames();
        this.planetManager = new PlanetManager(this.hullConfigManager, this.gameColors, this.itemManager);
        SolContactListener contactListener = new SolContactListener(this);
        this.factionManager = new FactionManager();
        this.objectManager = new ObjectManager(contactListener, this.factionManager);
        this.gridDrawer = new GridDrawer();
        this.chunkManager = new ChunkManager();
        this.partMan = new PartMan();
        this.asteroidBuilder = new AsteroidBuilder();
        this.lootBuilder = new LootBuilder();
        this.mapDrawer = new MapDrawer();
        this.shardBuilder = new ShardBuilder();
        this.galaxyFiller = new GalaxyFiller(this.hullConfigManager);
        this.starPortBuilder = new StarPort.Builder();
        this.drawableDebugger = new DrawableDebugger();
        this.mountDetectDrawer = new MountDetectDrawer();
        this.beaconHandler = new BeaconHandler();
        this.timeFactor = 1.0f;
        this.updateSystems = new TreeMap<Integer, List<UpdateAwareSystem>>();
        ArrayList<UpdateAwareSystem> defaultSystems = new ArrayList<UpdateAwareSystem>();
        defaultSystems.addAll(Arrays.asList(this.planetManager, this.camera, this.chunkManager, this.mountDetectDrawer, this.objectManager, this.mapDrawer, this.soundManager, this.beaconHandler, this.drawableDebugger));
        if (this.tutorialManager != null) {
            defaultSystems.add(this.tutorialManager);
        }
        this.updateSystems.put(0, defaultSystems);
        ArrayList<UpdateAwareSystem> defaultPausedSystems = new ArrayList<UpdateAwareSystem>();
        defaultPausedSystems.addAll(Arrays.asList(this.mapDrawer, this.camera, this.drawableDebugger));
        this.onPausedUpdateSystems = new TreeMap<Integer, List<UpdateAwareSystem>>();
        this.onPausedUpdateSystems.put(0, defaultPausedSystems);
        try {
            for (Class updateSystemClass : moduleManager.getEnvironment().getSubtypesOf(UpdateAwareSystem.class)) {
                ArrayList<UpdateAwareSystem> systems;
                if (!updateSystemClass.isAnnotationPresent(RegisterUpdateSystem.class)) continue;
                RegisterUpdateSystem registerAnnotation = updateSystemClass.getDeclaredAnnotation(RegisterUpdateSystem.class);
                UpdateAwareSystem system = (UpdateAwareSystem)updateSystemClass.newInstance();
                if (!registerAnnotation.paused()) {
                    if (!this.updateSystems.containsKey(registerAnnotation.priority())) {
                        systems = new ArrayList<UpdateAwareSystem>();
                        systems.add(system);
                        this.updateSystems.put(registerAnnotation.priority(), systems);
                        continue;
                    }
                    ((List)this.updateSystems.get(registerAnnotation.priority())).add(system);
                    continue;
                }
                if (!this.onPausedUpdateSystems.containsKey(registerAnnotation.priority())) {
                    systems = new ArrayList();
                    systems.add(system);
                    this.onPausedUpdateSystems.put(registerAnnotation.priority(), systems);
                    continue;
                }
                ((List)this.onPausedUpdateSystems.get(registerAnnotation.priority())).add(system);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.respawnState = new RespawnState();
        this.planetManager.fill(solNames, worldConfig.getNumberOfSystems());
        this.createGame(shipName, isNewGame);
        if (!isNewGame) {
            this.createAndSpawnMercenariesFromSave();
        }
        SolMath.checkVectorsTaken(null);
        Timer.schedule((Timer.Task)new Timer.Task(){

            public void run() {
                if (!SolGame.this.hero.isTranscendent()) {
                    SolGame.this.saveShip();
                }
            }
        }, (float)0.0f, (float)30.0f);
        this.gameScreens.consoleScreen.init(this);
    }

    private void createGame(String shipName, boolean shouldSpawnOnGalaxySpawnPosition) {
        boolean isNewShip = shipName != null;
        ShipConfig shipConfig = this.readShipFromConfigOrLoadFromSaveIfNull(shipName, isNewShip);
        if (!this.respawnState.isPlayerRespawned()) {
            this.galaxyFiller.fill(this, this.hullConfigManager, this.itemManager, shipConfig.hull.getInternalName().split(":")[0]);
        }
        this.hero = new PlayerCreator().createPlayer(shipConfig, shouldSpawnOnGalaxySpawnPosition, this.respawnState, this, this.solApplication.getOptions().controlType == GameOptions.ControlType.MOUSE, isNewShip);
        this.hero.initialise(this);
    }

    private ShipConfig readShipFromConfigOrLoadFromSaveIfNull(String shipName, boolean isNewShip) {
        if (isNewShip) {
            return ShipConfig.load(this.hullConfigManager, shipName, this.itemManager);
        }
        return SaveManager.readShip(this.hullConfigManager, this.itemManager);
    }

    private void createAndSpawnMercenariesFromSave() {
        List<MercItem> mercenaryItems = new MercenarySaveLoader().loadMercenariesFromSave(this.hullConfigManager, this.itemManager);
        for (MercItem mercenaryItem : mercenaryItems) {
            MercenaryUtils.createMerc(this, this.hero, mercenaryItem);
        }
    }

    public void onGameEnd(Context context) {
        if (this.hero.isDead()) {
            this.respawn();
        }
        if (!this.isTutorial) {
            if (!this.hero.isTranscendent()) {
                this.saveShip();
            }
            SaveManager.saveWorld(this.getPlanetManager().getSystems().size());
            try {
                context.get(SerialisationManager.class).serialise();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            context.get(EntitySystemManager.class).getEntityManager().allEntities().forEach(EntityRef::delete);
        } else {
            context.remove(TutorialManager.class, this.tutorialManager);
        }
        this.objectManager.dispose();
    }

    private void saveShip() {
        List<SolItem> items;
        float money;
        HullConfig hull;
        if (this.hero.isTranscendent()) {
            throw new SolException("The hero cannot be saved when in a transcendent state.");
        }
        if (this.hero.isAlive()) {
            hull = this.hero.isTranscendent() ? this.hero.getTranscendentHero().getShip().getHullConfig() : this.hero.getHull().config;
            money = this.hero.getMoney();
            items = new ArrayList<SolItem>();
            for (List<SolItem> group : this.hero.getItemContainer()) {
                for (SolItem i : group) {
                    items.add(0, i);
                }
            }
        } else {
            hull = this.respawnState.getRespawnHull();
            money = this.respawnState.getRespawnMoney();
            items = this.respawnState.getRespawnItems();
        }
        SaveManager.writeShips(hull, money, items, this.hero, this.hullConfigManager);
    }

    public GameScreens getScreens() {
        return this.gameScreens;
    }

    public void update() {
        if (this.paused) {
            this.onPausedUpdateSystems.keySet().forEach(key -> ((List)this.onPausedUpdateSystems.get(key)).forEach(system -> system.update(this, this.timeStep)));
        } else {
            this.updateTime();
            this.updateSystems.keySet().forEach(key -> ((List)this.updateSystems.get(key)).forEach(system -> system.update(this, this.timeStep)));
        }
    }

    private void updateTime() {
        this.scaleTimeStep();
        this.time += this.timeStep;
    }

    private void scaleTimeStep() {
        ShipAbility ability;
        this.timeFactor = DebugOptions.GAME_SPEED_MULTIPLIER;
        if (this.hero.isAlive() && this.hero.isNonTranscendent() && (ability = this.hero.getAbility()) instanceof SloMo) {
            float factor = ((SloMo)ability).getFactor();
            this.timeFactor *= factor;
        }
        this.timeStep = 0.016666668f * this.timeFactor;
    }

    public void draw() {
        this.drawableManager.draw(this);
    }

    public void drawDebug(GameDrawer drawer) {
        if (DebugOptions.GRID_SZ > 0.0f) {
            this.gridDrawer.draw(drawer, this, DebugOptions.GRID_SZ, drawer.debugWhiteTexture);
        }
        this.planetManager.drawDebug(drawer, this);
        this.objectManager.drawDebug(drawer, this);
        if (DebugOptions.ZOOM_OVERRIDE != 0.0f) {
            this.camera.drawDebug(drawer);
        }
        this.drawDebugPoint(drawer, DebugOptions.DEBUG_POINT, DebugCol.POINT);
        this.drawDebugPoint(drawer, DebugOptions.DEBUG_POINT2, DebugCol.POINT2);
        this.drawDebugPoint(drawer, DebugOptions.DEBUG_POINT3, DebugCol.POINT3);
    }

    private void drawDebugPoint(GameDrawer drawer, Vector2 dp, Color col) {
        if (dp.x != 0.0f || dp.y != 0.0f) {
            float sz = this.camera.getRealLineWidth() * 5.0f;
            drawer.draw((TextureRegion)drawer.debugWhiteTexture, sz, sz, sz / 2.0f, sz / 2.0f, dp.x, dp.y, 0.0f, col);
        }
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public SolCam getCam() {
        return this.camera;
    }

    public DrawableManager getDrawableManager() {
        return this.drawableManager;
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    public PlanetManager getPlanetManager() {
        return this.planetManager;
    }

    public PartMan getPartMan() {
        return this.partMan;
    }

    public AsteroidBuilder getAsteroidBuilder() {
        return this.asteroidBuilder;
    }

    public LootBuilder getLootBuilder() {
        return this.lootBuilder;
    }

    public Hero getHero() {
        return this.hero;
    }

    public ShipBuilder getShipBuilder() {
        return this.shipBuilder;
    }

    public ItemManager getItemMan() {
        return this.itemManager;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        DebugCollector.warn(this.paused ? "game paused" : "game resumed");
    }

    public void respawn() {
        this.respawnState.setPlayerRespawned(true);
        if (this.hero.isAlive()) {
            this.setRespawnState();
            this.objectManager.removeObjDelayed(this.hero.getShip());
        }
        this.createGame(null, true);
    }

    public FactionManager getFactionMan() {
        return this.factionManager;
    }

    public boolean isPlaceEmpty(Vector2 position, boolean considerPlanets) {
        SolSystem ns;
        if (considerPlanets) {
            boolean inPlanet;
            Planet np = this.planetManager.getNearestPlanet(position);
            boolean bl = inPlanet = np.getPosition().dst(position) < np.getFullHeight();
            if (inPlanet) {
                return false;
            }
        }
        if ((ns = this.planetManager.getNearestSystem(position)).getPosition().dst(position) < 58.5f) {
            return false;
        }
        List<SolObject> objs = this.objectManager.getObjects();
        for (SolObject o : objs) {
            if (!o.hasBody() || !(position.dst(o.getPosition()) < this.objectManager.getRadius(o).floatValue())) continue;
            return false;
        }
        for (FarObjData fod : this.objectManager.getFarObjs()) {
            FarObject o = fod.fo;
            if (!o.hasBody() || !(position.dst(o.getPosition()) < o.getRadius())) continue;
            return false;
        }
        return true;
    }

    public MapDrawer getMapDrawer() {
        return this.mapDrawer;
    }

    public ShardBuilder getShardBuilder() {
        return this.shardBuilder;
    }

    public FarBackgroundManagerOld getFarBackgroundgManagerOld() {
        return this.farBackgroundManagerOld;
    }

    public GalaxyFiller getGalaxyFiller() {
        return this.galaxyFiller;
    }

    public StarPort.Builder getStarPortBuilder() {
        return this.starPortBuilder;
    }

    public GridDrawer getGridDrawer() {
        return this.gridDrawer;
    }

    public OggSoundManager getSoundManager() {
        return this.soundManager;
    }

    public float getTime() {
        return this.time;
    }

    public void drawDebugUi(UiDrawer uiDrawer) {
        this.drawableDebugger.draw(uiDrawer);
    }

    public SpecialSounds getSpecialSounds() {
        return this.specialSounds;
    }

    public SpecialEffects getSpecialEffects() {
        return this.specialEffects;
    }

    public GameColors getCols() {
        return this.gameColors;
    }

    public float getTimeFactor() {
        return this.timeFactor;
    }

    public BeaconHandler getBeaconHandler() {
        return this.beaconHandler;
    }

    public MountDetectDrawer getMountDetectDrawer() {
        return this.mountDetectDrawer;
    }

    public TutorialManager getTutMan() {
        return this.tutorialManager;
    }

    public void setRespawnState() {
        this.respawnState.setRespawnMoney(0.75f * this.hero.getMoney());
        this.hero.setMoney(this.respawnState.getRespawnMoney());
        this.respawnState.setRespawnHull(this.hero.isNonTranscendent() ? this.hero.getHull().getHullConfig() : this.hero.getTranscendentHero().getShip().getHullConfig());
        this.respawnState.getRespawnItems().clear();
        this.respawnState.getRespawnWaypoints().clear();
        this.respawnState.setPlayerRespawned(true);
        for (List<SolItem> group : this.hero.getItemContainer()) {
            for (SolItem item : group) {
                boolean equipped;
                boolean bl = equipped = this.hero.isTranscendent() || this.hero.maybeUnequip(this, item, false);
                if (!equipped && !SolRandom.test(0.75f)) continue;
                this.respawnState.getRespawnItems().add(item);
            }
        }
        for (Waypoint waypoint : this.hero.getWaypoints()) {
            this.respawnState.getRespawnWaypoints().add(waypoint);
        }
    }

    public boolean isTutorial() {
        return this.isTutorial;
    }

    public SolApplication getSolApplication() {
        return this.solApplication;
    }

    public HullConfigManager getHullConfigManager() {
        return this.hullConfigManager;
    }
}

