/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.Bound;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SaveManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.particle.EffectConfig;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.ForceBeacon;
import org.destinationsol.game.ship.SolShip;

public class StarPort
implements SolObject {
    public static final int SIZE = 8;
    private static final float DIST_FROM_PLANET = 4.0f;
    private static final float FARE = 10.0f;
    private final Body body;
    private final ArrayList<LightSource> lightSources;
    private final Vector2 position;
    private final Planet fromPlanet;
    private final Planet toPlanet;
    private final ArrayList<Drawable> drawables;
    private final boolean isSecondary;
    private float angle;

    StarPort(Planet from, Planet to, Body body, ArrayList<Drawable> drawables, boolean secondary, ArrayList<LightSource> lights) {
        this.fromPlanet = from;
        this.toPlanet = to;
        this.drawables = drawables;
        this.body = body;
        this.lightSources = lights;
        this.position = new Vector2();
        this.setParamsFromBody();
        this.isSecondary = secondary;
    }

    private static void blip(SolGame game, SolShip ship) {
        TextureAtlas.AtlasRegion texture = Assets.getAtlasRegion("engine:teleportBlip");
        float blipSize = ship.getHull().config.getApproxRadius() * 10.0f;
        game.getPartMan().blip(game, ship.getPosition(), SolRandom.randomFloat(180.0f), blipSize, 1.0f, Vector2.Zero, texture);
    }

    @Bound
    public static Vector2 getDesiredPosition(Planet from, Planet to, boolean precise) {
        Vector2 fromPosition = from.getPosition();
        float angle = SolMath.angle(fromPosition, to.getPosition());
        Vector2 position = SolMath.getVec();
        SolMath.fromAl(position, angle, from.getFullHeight() + 4.0f);
        position.add(fromPosition);
        return position;
    }

    private static Vector2 adjustDesiredPos(SolGame game, StarPort port, Vector2 desired) {
        Vector2 newPosition = desired;
        List<SolObject> objects = game.getObjectManager().getObjects();
        for (SolObject object : objects) {
            if (!(object instanceof StarPort) || object == port) continue;
            StarPort starPort = (StarPort)object;
            Vector2 fromPosition = starPort.getPosition();
            Vector2 distanceVector = SolMath.distVec(fromPosition, desired);
            float distance = SolMath.hypotenuse(distanceVector.x, distanceVector.y);
            if (distance <= 8.0f) {
                distanceVector.scl(8.5f / distance);
                newPosition = fromPosition.cpy().add(distanceVector);
            }
            SolMath.free(distanceVector);
        }
        return newPosition;
    }

    @Override
    public void update(SolGame game) {
        this.setParamsFromBody();
        float fps = 1.0f / game.getTimeStep();
        Vector2 velocity = StarPort.getDesiredPosition(this.fromPlanet, this.toPlanet, true);
        velocity = StarPort.adjustDesiredPos(game, this, velocity);
        velocity.sub(this.position).scl(fps / 4.0f);
        this.body.setLinearVelocity(velocity);
        SolMath.free(velocity);
        float desiredAngle = SolMath.angle(this.fromPlanet.getPosition(), this.toPlanet.getPosition());
        this.body.setAngularVelocity((desiredAngle - this.angle) * ((float)Math.PI / 180) * fps / 4.0f);
        SolShip ship = ForceBeacon.pullShips(game, this, this.position, null, null, 3.2f);
        if (ship != null && ship.getMoney() >= 10.0f && ship.getPosition().dst(this.position) < 0.4f) {
            ship.setMoney(ship.getMoney() - 10.0f);
            Transcendent transcendent = new Transcendent(ship, this.fromPlanet, this.toPlanet, game);
            if (transcendent.getShip().getPilot().isPlayer()) {
                SaveManager.saveWorld(game.getPlanetManager().getSystems().size());
                game.getHero().setTranscendent(transcendent);
            }
            ObjectManager objectManager = game.getObjectManager();
            objectManager.addObjDelayed(transcendent);
            StarPort.blip(game, ship);
            game.getSoundManager().play(game, game.getSpecialSounds().transcendentCreated, null, transcendent);
            objectManager.removeObjDelayed(ship);
        }
        for (LightSource light : this.lightSources) {
            light.update(true, this.angle, game);
        }
    }

    public boolean isSecondary() {
        return this.isSecondary;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
        this.body.getWorld().destroyBody(this.body);
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        game.getSpecialSounds().playHit(game, this, position, dmgType);
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return new FarStarPort(this.fromPlanet, this.toPlanet, this.position, this.isSecondary);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.angle = this.body.getAngle() * 57.295776f;
    }

    public Planet getFromPlanet() {
        return this.fromPlanet;
    }

    public Planet getToPlanet() {
        return this.toPlanet;
    }

    public static class Transcendent
    implements SolObject {
        private static final float TRAN_SZ = 1.0f;
        private static final String TRANSCENDENT_SPRITE_NAME = "engine:transcendent";
        private final Planet fromPlanet;
        private final Planet toPlanet;
        private final Vector2 position;
        private final Vector2 destinationPosition;
        private final ArrayList<Drawable> drawables;
        private final FarShip ship;
        private final Vector2 velocity;
        private final LightSource lightSource;
        private final DSParticleEmitter effect;
        private float angle;

        public Transcendent(SolShip ship, Planet from, Planet to, SolGame game) {
            this.ship = ship.toFarObject();
            this.fromPlanet = from;
            this.toPlanet = to;
            this.position = new Vector2(ship.getPosition());
            this.velocity = new Vector2();
            this.destinationPosition = new Vector2();
            RectSprite s = SpriteManager.createSprite(TRANSCENDENT_SPRITE_NAME, 1.0f, 0.3f, 0.0f, new Vector2(), DrawableLevel.PROJECTILES, 0.0f, 0.0f, SolColor.WHITE, false);
            this.drawables = new ArrayList();
            this.drawables.add(s);
            EffectConfig eff = game.getSpecialEffects().transcendentWork;
            this.effect = new DSParticleEmitter(eff, 1.0f, DrawableLevel.PART_BG_0, new Vector2(), true, game, this.position, Vector2.Zero, 0.0f);
            this.effect.setWorking(true);
            this.drawables.addAll(this.effect.getDrawables());
            this.lightSource = new LightSource(0.6f, true, 0.5f, new Vector2(), eff.tint);
            this.lightSource.collectDrawables(this.drawables);
            this.setDependentParams();
        }

        public FarShip getShip() {
            return this.ship;
        }

        @Override
        public void update(SolGame game) {
            this.setDependentParams();
            float timeStep = game.getTimeStep();
            Vector2 moveDiff = SolMath.getVec(this.velocity);
            moveDiff.scl(timeStep);
            this.position.add(moveDiff);
            SolMath.free(moveDiff);
            if (this.position.dst(this.destinationPosition) < 0.5f) {
                ObjectManager objectManager = game.getObjectManager();
                objectManager.removeObjDelayed(this);
                this.ship.setPos(this.position);
                this.ship.setVelocity(new Vector2());
                SolShip ship = this.ship.toObject(game);
                if (ship.getPilot().isPlayer()) {
                    game.getHero().setSolShip(ship, game);
                    SaveManager.saveWorld(game.getPlanetManager().getSystems().size());
                }
                objectManager.addObjDelayed(ship);
                StarPort.blip(game, ship);
                game.getSoundManager().play(game, game.getSpecialSounds().transcendentFinished, null, this);
                game.getObjectManager().resetDelays();
            } else {
                game.getSoundManager().play(game, game.getSpecialSounds().transcendentMove, null, this);
                this.lightSource.update(true, this.angle, game);
            }
        }

        private void setDependentParams() {
            Vector2 toPosition = this.toPlanet.getPosition();
            float nodeAngle = SolMath.angle(toPosition, this.fromPlanet.getPosition());
            SolMath.fromAl(this.destinationPosition, nodeAngle, this.toPlanet.getFullHeight() + 4.0f + 4.0f);
            this.destinationPosition.add(toPosition);
            this.angle = SolMath.angle(this.position, this.destinationPosition);
            SolMath.fromAl(this.velocity, this.angle, 16.0f);
        }

        @Override
        public boolean shouldBeRemoved(SolGame game) {
            return false;
        }

        @Override
        public void onRemove(SolGame game) {
            game.getPartMan().finish(game, this.effect, this.position);
        }

        @Override
        public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
            game.getSpecialSounds().playHit(game, this, position, dmgType);
        }

        @Override
        public boolean receivesGravity() {
            return false;
        }

        @Override
        public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        }

        @Override
        public Vector2 getPosition() {
            return this.position;
        }

        @Override
        public FarObject toFarObject() {
            return null;
        }

        @Override
        public List<Drawable> getDrawables() {
            return this.drawables;
        }

        @Override
        public float getAngle() {
            return this.angle;
        }

        @Override
        public Vector2 getVelocity() {
            return this.velocity;
        }

        @Override
        public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
        }

        @Override
        public String toDebugString() {
            return null;
        }

        @Override
        public Boolean isMetal() {
            return null;
        }

        @Override
        public boolean hasBody() {
            return false;
        }
    }

    public static class FarStarPort
    implements FarObject {
        private final Planet fromPlanet;
        private final Planet toPlanet;
        private final Vector2 position;
        private final boolean isSecondary;
        private float angle;

        FarStarPort(Planet from, Planet to, Vector2 position, boolean secondary) {
            this.fromPlanet = from;
            this.toPlanet = to;
            this.position = new Vector2(position);
            this.isSecondary = secondary;
        }

        @Override
        public boolean shouldBeRemoved(SolGame game) {
            return false;
        }

        @Override
        public SolObject toObject(SolGame game) {
            return game.getStarPortBuilder().build(game, this.fromPlanet, this.toPlanet, this.isSecondary);
        }

        @Override
        public void update(SolGame game) {
            Vector2 desiredPosition = StarPort.getDesiredPosition(this.fromPlanet, this.toPlanet, false);
            this.position.set(desiredPosition);
            SolMath.free(desiredPosition);
            this.angle = SolMath.angle(this.fromPlanet.getPosition(), this.toPlanet.getPosition());
        }

        @Override
        public float getRadius() {
            return 4.0f;
        }

        @Override
        public Vector2 getPosition() {
            return this.position;
        }

        @Override
        public String toDebugString() {
            return null;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        public Planet getFrom() {
            return this.fromPlanet;
        }

        public Planet getTo() {
            return this.toPlanet;
        }

        public float getAngle() {
            return this.angle;
        }

        public boolean isSecondary() {
            return this.isSecondary;
        }
    }

    public static class Builder {
        public static final float FLOW_DIST = 2.08f;
        private final CollisionMeshLoader myLoader = new CollisionMeshLoader("engine:miscCollisionMeshes");

        Builder() {
        }

        public StarPort build(SolGame game, Planet from, Planet to, boolean secondary) {
            float angle = SolMath.angle(from.getPosition(), to.getPosition());
            Vector2 position = StarPort.getDesiredPosition(from, to, false);
            position = StarPort.adjustDesiredPos(game, null, position);
            ArrayList<Drawable> drawables = new ArrayList<Drawable>();
            Body body = this.myLoader.getBodyAndSprite(game.getObjectManager().getWorld(), Assets.getAtlasRegion("engine:starPort"), 8.0f, BodyDef.BodyType.KinematicBody, new Vector2(position), angle, drawables, 10.0f, DrawableLevel.BIG_BODIES);
            SolMath.free(position);
            ArrayList<LightSource> lights = new ArrayList<LightSource>();
            this.addFlow(game, position, drawables, 0.0f, lights);
            this.addFlow(game, position, drawables, 90.0f, lights);
            this.addFlow(game, position, drawables, -90.0f, lights);
            this.addFlow(game, position, drawables, 180.0f, lights);
            DSParticleEmitter force = game.getSpecialEffects().buildForceBeacon(3.12f, game, new Vector2(), position, Vector2.Zero);
            force.setWorking(true);
            drawables.addAll(force.getDrawables());
            StarPort sp = new StarPort(from, to, body, drawables, secondary, lights);
            body.setUserData((Object)sp);
            return sp;
        }

        private void addFlow(SolGame game, Vector2 position, ArrayList<Drawable> drawables, float angle, ArrayList<LightSource> lights) {
            EffectConfig flow = game.getSpecialEffects().starPortFlow;
            Vector2 relPos = new Vector2();
            SolMath.fromAl(relPos, angle, -2.08f);
            DSParticleEmitter f1 = new DSParticleEmitter(flow, 2.08f, DrawableLevel.PART_BG_0, relPos, false, game, position, Vector2.Zero, angle);
            f1.setWorking(true);
            drawables.addAll(f1.getDrawables());
            LightSource light = new LightSource(0.6f, true, 1.0f, relPos, flow.tint);
            light.collectDrawables(drawables);
            lights.add(light);
        }
    }
}

