/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.asteroid;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.asteroid.FarAsteroid;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.item.Loot;
import org.destinationsol.game.item.MoneyItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.TileObject;

public class Asteroid
implements SolObject {
    private static final float MIN_SPLIT_SZ = 0.25f;
    private static final float MIN_BURN_SZ = 0.3f;
    private static final float SZ_TO_LIFE = 20.0f;
    private static final float SPD_TO_ATM_DMG = 2.2f;
    private static final float MAX_SPLIT_SPD = 1.0f;
    private static final float DUR = 0.5f;
    private final Body body;
    private final Vector2 position;
    private final Vector2 velocity;
    private final ArrayList<Drawable> drawables;
    private final TextureAtlas.AtlasRegion texture;
    private final RemoveController removeController;
    private final DSParticleEmitter smokeSource;
    private final DSParticleEmitter fireSource;
    private final float mass;
    private float angle;
    private float life;
    private float size;

    Asteroid(SolGame game, TextureAtlas.AtlasRegion tex, Body body, float size, RemoveController removeController, ArrayList<Drawable> drawables) {
        this.texture = tex;
        this.removeController = removeController;
        this.drawables = drawables;
        this.body = body;
        this.size = size;
        this.life = 20.0f * size;
        this.position = new Vector2();
        this.velocity = new Vector2();
        this.mass = body.getMass();
        this.setParamsFromBody();
        List<DSParticleEmitter> effects = game.getSpecialEffects().buildBodyEffs(size / 2.0f, game, this.position, this.velocity);
        this.smokeSource = effects.get(0);
        this.fireSource = effects.get(1);
        this.drawables.addAll(this.smokeSource.getDrawables());
        this.drawables.addAll(this.fireSource.getDrawables());
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        float rotationSpeed = this.body.getAngularVelocity();
        return new FarAsteroid(this.texture, this.position, this.angle, this.removeController, this.size, this.velocity, rotationSpeed);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return this.velocity;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
        float dmg = other instanceof TileObject && 0.3f < this.size ? this.life : absImpulse / this.mass / 0.5f;
        this.receiveDmg(dmg, game, collPos, DmgType.CRASH);
    }

    @Override
    public String toDebugString() {
        return "Asteroid size: " + this.size;
    }

    @Override
    public Boolean isMetal() {
        return false;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public void update(SolGame game) {
        boolean burning = this.updateInAtm(game);
        this.smokeSource.setWorking(burning);
        this.fireSource.setWorking(burning);
        this.setParamsFromBody();
    }

    private boolean updateInAtm(SolGame game) {
        Planet np = game.getPlanetManager().getNearestPlanet();
        float dst = np.getPosition().dst(this.position);
        if (np.getFullHeight() < dst) {
            return false;
        }
        if (0.3f >= this.size) {
            return false;
        }
        float dmg = this.body.getLinearVelocity().len() * 2.2f * game.getTimeStep();
        this.receiveDmg(dmg, game, null, DmgType.FIRE);
        return true;
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.velocity.set(this.body.getLinearVelocity());
        this.angle = this.body.getAngle() * 57.295776f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.life <= 0.0f || this.removeController != null && this.removeController.shouldRemove(this.position);
    }

    @Override
    public void onRemove(SolGame game) {
        game.getPartMan().finish(game, this.smokeSource, this.position);
        game.getPartMan().finish(game, this.fireSource, this.position);
        this.body.getWorld().destroyBody(this.body);
        if (this.life <= 0.0f) {
            game.getSpecialEffects().asteroidDust(game, this.position, this.velocity, this.size);
            float vol = SolMath.clamp(this.size / 0.5f);
            game.getSoundManager().play(game, game.getSpecialSounds().asteroidCrack, null, this, vol);
            this.maybeSplit(game);
        }
    }

    private void maybeSplit(SolGame game) {
        Asteroid a;
        if (0.25f > this.size) {
            return;
        }
        for (float sclSum = 0.0f; sclSum < 0.7f * this.size * this.size; sclSum += a.size * a.size) {
            float velocityAngle = SolRandom.randomFloat(180.0f);
            Vector2 velocity = new Vector2();
            SolMath.fromAl(velocity, velocityAngle, SolRandom.randomFloat(0.0f, 0.5f) * 1.0f);
            velocity.add(velocity);
            Vector2 newPos = new Vector2();
            SolMath.fromAl(newPos, velocityAngle, SolRandom.randomFloat(0.0f, this.size / 2.0f));
            newPos.add(this.position);
            float sz = this.size * SolRandom.randomFloat(0.25f, 0.5f);
            a = game.getAsteroidBuilder().buildNew(game, newPos, velocity, sz, this.removeController);
            game.getObjectManager().addObjDelayed(a);
        }
        float thrMoney = this.size * 40.0f * SolRandom.randomFloat(0.3f, 1.0f);
        List<MoneyItem> moneyItems = game.getItemMan().moneyToItems(thrMoney);
        for (MoneyItem mi : moneyItems) {
            this.throwLoot(game, mi);
        }
    }

    private void throwLoot(SolGame game, SolItem item) {
        float velocityAngle = SolRandom.randomFloat(180.0f);
        Vector2 lootVelocity = new Vector2();
        SolMath.fromAl(lootVelocity, velocityAngle, SolRandom.randomFloat(0.0f, 0.2f));
        lootVelocity.add(this.velocity);
        Vector2 lootPosition = new Vector2();
        SolMath.fromAl(lootPosition, velocityAngle, SolRandom.randomFloat(0.0f, this.size / 2.0f));
        lootPosition.add(this.position);
        Loot l = game.getLootBuilder().build(game, lootPosition, item, lootVelocity, 6, SolRandom.randomFloat(4.0f), null);
        game.getObjectManager().addObjDelayed(l);
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        this.life -= dmg;
        game.getSpecialSounds().playHit(game, this, position, dmgType);
    }

    @Override
    public boolean receivesGravity() {
        return true;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        if (acc) {
            force.scl(this.mass);
        }
        this.body.applyForceToCenter(force, true);
    }

    public float getLife() {
        return this.life;
    }
}

