/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.asteroid;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.RemoveController;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.asteroid.Asteroid;
import org.destinationsol.game.asteroid.FarAsteroid;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;

public class AsteroidBuilder {
    private static final float DENSITY = 10.0f;
    private static final float MAX_A_ROT_SPD = 0.5f;
    private static final float MAX_BALL_SZ = 0.2f;
    private final CollisionMeshLoader collisionMeshLoader = new CollisionMeshLoader("engine:asteroids");
    private final List<TextureAtlas.AtlasRegion> textures = Assets.listTexturesMatching("engine:asteroid_.*");

    public static Body buildBall(SolGame game, Vector2 position, float angle, float rad, float density, boolean sensor) {
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.angle = angle * ((float)Math.PI / 180);
        bodyDef.angularDamping = 0.0f;
        bodyDef.position.set(position);
        bodyDef.linearDamping = 0.0f;
        Body body = game.getObjectManager().getWorld().createBody(bodyDef);
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.density = density;
        fixtureDef.friction = 0.5f;
        fixtureDef.shape = new CircleShape();
        fixtureDef.shape.setRadius(rad);
        fixtureDef.isSensor = sensor;
        body.createFixture(fixtureDef);
        fixtureDef.shape.dispose();
        return body;
    }

    public Asteroid buildNew(SolGame game, Vector2 position, Vector2 velocity, float size, RemoveController removeController) {
        float rotationSpeed = SolRandom.randomFloat(0.5f);
        return this.build(game, position, SolRandom.randomElement(this.textures), size, SolRandom.randomFloat(180.0f), rotationSpeed, velocity, removeController);
    }

    public FarAsteroid buildNewFar(Vector2 position, Vector2 velocity, float size, RemoveController removeController) {
        float rotationSpeed = SolRandom.randomFloat(0.5f);
        return new FarAsteroid(SolRandom.randomElement(this.textures), new Vector2(position), SolRandom.randomFloat(180.0f), removeController, size, new Vector2(velocity), rotationSpeed);
    }

    public Asteroid build(SolGame game, Vector2 position, TextureAtlas.AtlasRegion texture, float size, float angle, float rotationSpeed, Vector2 velocity, RemoveController removeController) {
        Body body;
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        if (0.2f < size) {
            body = this.collisionMeshLoader.getBodyAndSprite(game.getObjectManager().getWorld(), texture, size, BodyDef.BodyType.DynamicBody, position, angle, drawables, 10.0f, DrawableLevel.BODIES);
        } else {
            body = AsteroidBuilder.buildBall(game, position, angle, size / 2.0f, 10.0f, false);
            RectSprite s = SpriteManager.createSprite(texture.name, size, 0.0f, 0.0f, new Vector2(), DrawableLevel.BODIES, 0.0f, 0.0f, SolColor.WHITE, false);
            drawables.add(s);
        }
        body.setAngularVelocity(rotationSpeed);
        body.setLinearVelocity(velocity);
        Asteroid asteroid = new Asteroid(game, texture, body, size, removeController, drawables);
        body.setUserData((Object)asteroid);
        return asteroid;
    }
}

